/* **********************************************************************
 *
 *  BBNT Solutions LLC, A part of GTE
 *  10 Moulton St.
 *  Cambridge, MA 02138
 *  (617) 873-2000
 *
 *  Copyright (C) 1998, 2000
 *  This software is subject to copyright protection under the laws of
 *  the United States and other countries.
 *
 * **********************************************************************
 *
 * $Source: /net/bitburg/u4/distapps/rcs/openmap/com/bbn/openmap/examples/hello/TextLayer.java,v $
 * $Revision: 1.3 $
 * $Date: 2000/05/08 14:22:09 $
 * $Author: wjeuerle $
 *
 * **********************************************************************
 */

package org.trinet.map;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;

public class TextLayer extends Layer
{

    // Projection projection;  // not needed in this very simple layer

    /**
     * During construction, we'll fill this with this Font we wish
     * to use
     */
    Font font;

    /**
     * Construct a TextLayer instance.
     */
    public TextLayer () {
	font = new Font("TimesRoman", Font.BOLD + Font.ITALIC, 48);
//	setName("Hello, world");	// pretty name for menus
	setName("Bite me!");	// pretty name for menus
    }

    /**
     * In this method we paint on the screen whatever is appropriate
     * for this layer.
     */
    public void paint (Graphics g) {
	Rectangle r = g.getClipBounds();
	int halfHeight = r.height / 2;
	int halfWidth = r.width / 2;
	g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
	int halfStringWidth = fm.stringWidth(HelloWorld.message) / 2;
	g.setColor(Color.red);
	g.drawString(HelloWorld.message,
		     halfWidth - halfStringWidth, halfHeight);
    }

    /**
     * We have to implement this method.  In this simple case,
     * it turns out we don't have to reshape our "Hello, World!"
     * display for the projection, so this method becomes a NOP.
     *
     * Normally in this method we would get the projection,
     * and then either send it a forward message, or send an
     * OMGraphics the project message, and then call repaint().
     */
    public void projectionChanged (ProjectionEvent e) {
    }

}
