package org.trinet.jiggle;

import java.awt.event.*;
import java.util.*;
import java.text.*;
import javax.swing.*;
import javax.swing.event.*;
import org.trinet.util.*;

/**
 * A comboBox for selecting how many seconds are visible in the viewport of a
 * ZoomPanel. Its selected value will change if the MasterWFVModel is changed
 * somewhere else so it always reflects the correct value.
 *
 *
 * @author Doug Given
 * */

/*
 * Strangely there don't seem to be any recursion problems here.
 */

public class ZoomScaleComboBox extends JComboBox // implements Observer
{

    //String current = "  ";
    //String editedItem = "  ";
    String nonList;

    DecimalFormat df = new DecimalFormat ( "##0.00" );  // distance format

    ZoomScaleComboHandler handler = new ZoomScaleComboHandler();

    // list of values in the combobox, reserve the 0th entry for non-list values
    static final String defList[] = {"   ",
      "1.00",
      "2.00",
      "5.00",
      "10.00",
      "20.00",
      "30.00",
      "60.00",
      "90.00"};

    String valList[] = defList;

      /** The master view, need for MVC interaction. */
    MasterView mv;

    /** List is an array of strings that will appear in the combo box. They
    * must be readable as numbers either int or double. */
    public ZoomScaleComboBox(String[] list) {

      if (list != null) setList(list);

      setEditable(true);		    // allow freeform user input
      addActionListener(handler);
    }
    /** Constructor */
    public ZoomScaleComboBox() {
       this(defList);
    }

    /** Constructor */
    public ZoomScaleComboBox(MasterView masterview) {

      this();
      mv = masterview;
      mv.masterWFWindowModel.addChangeListener(new WFWindowListener());
    }

    public void setList (String[] list) {

      valList = list;

      // clear comboBox, if empty removeAllItems() cacks
      if (this.getItemCount() > 0) this.removeAllItems();
      for (int i = 0; i < valList.length; i++) {
        addItem(valList[i]);
      }
      nonList = (String) this.getSelectedItem();
      setSelectedItem(nonList);	    // default selection
      setMaximumRowCount(valList.length);   // items displayed in scrolling window
    }
    /** Set the current value of the selected item equal to this value. Formats
        the double value as "##0.00". */
    public void setCurrentValue (double val) {

	setCurrentValue(df.format(val));

    }
    /** Set the current value of the selected item equal to this string. */
    // This doesn't behave right. If a value in the list is selected then
    // another value is selected the original value is removed!
    // Don't know how to fix this without a methed that allows me to examine the list.
    public void setCurrentValue (String str) {

    // its in the list
     if (valListContains(str)) {
       setSelectedItem(str);         /// this fires the action listener
    // not in the list, stick it in the 0th spot
     } else {
	  removeItem(nonList);

	  nonList = str;

	  insertItemAt(nonList, 0);

	  setSelectedItem(nonList);        /// this fires the action listener
     }

    }
    /** Returns true if the string is in the value list. */
    private boolean valListContains (String str) {
       for (int i = 0; i < valList.length; i++) {
        if (valList[i].equals(str)) return true;
      }
      return false;

    }

/** INNER CLASS: Handle changes to the selected channel. */
      class WFWindowListener implements ChangeListener {

     	public void stateChanged (ChangeEvent changeEvent) {

  	      double val = mv.masterWFWindowModel.getTimeSize();

      // must turn off the comboBox event handler when responding to an external
      // change or setCurrentValue() will cause recursion thrash.
            removeActionListener(handler);
	       setCurrentValue(val);
            addActionListener(handler);

          }
      }

       public double getValue() {
          try {
  	      return Double.valueOf(((String)getSelectedItem()).trim()).doubleValue();
         } catch (Exception ex) {return -1;}    // -1 if bad entry
       }

/** Handle change of zoom scale to a specific value in seconds as set by
 *  this combo box.  */
    class ZoomScaleComboHandler implements ActionListener {

	/** If someone types in a scale value, do it. */
	public void actionPerformed(ActionEvent e)
	{
	    ZoomScaleComboBox jc = (ZoomScaleComboBox) e.getSource();

	    String selItem = (String) jc.getSelectedItem();
            double windowSize = 0.0;

         try {
  	      windowSize = Double.valueOf(selItem.trim()).doubleValue();
         } catch (Exception ex) {return;}    // bail if bad entry

         if (mv != null) {
           // reset the zoomed box and tell the Model
//	      TimeSpan ts = new TimeSpan(0.0, windowSize);
//	      ts.setCenter(mv.masterWFWindowModel.getTimeSpan().getCenter());
//	      mv.masterWFWindowModel.setTimeSpan(ts);
	      mv.masterWFWindowModel.setTimeSpanDuration(windowSize);
         }
	 }

    }

} // ZoomScaleComboBox
