package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.border.*;

/**
 * The MainStatusBar will be visible at the bottom of the frame at all times.
 * This is a passive object that shows information but has no buttons etc.
 * It contains the following components: <p>
 *  o A text label that is describes the current action thats happening. <p>
 *  o A progress bar that shows that progress of the current action.<p>
 *  o A label that shows how many traces there are in the current MasterView<p>
 */
public class MainStatusBar extends JPanel {

    StatusPanel statusPanel = new StatusPanel();

    private JLabel viewCountLabel = new JLabel();
    private JLabel phaseCountLabel = new JLabel();
    private JLabel ampCountLabel = new JLabel();
    private JLabel codaCountLabel = new JLabel();
    private JLabel solCountLabel = new JLabel();

    private JLabel dataSourceLabel = new JLabel();
    private JLabel wfSourceLabel = new JLabel();
    private JLabel mvModelLabel = new JLabel();

public MainStatusBar () {

      setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );

// Text label
      statusPanel.setText("Status text shows here");
//      statusLabel.setPreferredSize(Dimension size);
      add(statusPanel);

      statusPanel.setBorder(new EtchedBorder());

//      add(Box.createGlue();

      add(dataSourceLabel);
      dataSourceLabel.setBorder(new EtchedBorder());

      add(wfSourceLabel);
      wfSourceLabel.setBorder(new EtchedBorder());

      add(mvModelLabel);
      mvModelLabel.setBorder(new EtchedBorder());

      add(Box.createGlue());

// WFViewCount label
      add(viewCountLabel);
      viewCountLabel.setBorder(new EtchedBorder());
//      viewCountLabel.setText("0000 Chnls");	// insure we have enough room
      setWFViewCount(0);

// solCount label
      add(solCountLabel);
      solCountLabel.setBorder(new EtchedBorder());
//      solCountLabel.setText("0000 Solutions");	// insure we have enough room
      setSolutionCount(0);

// phaseCount label
      add(phaseCountLabel);
      phaseCountLabel.setBorder(new EtchedBorder());
//      phaseCountLabel.setText("0000 Phases");	// insure we have enough room
      setPhaseCount(0);

// ampCount label
      add(ampCountLabel);
      ampCountLabel.setBorder(new EtchedBorder());
//      ampCountLabel.setText("0000 Amps");	// insure we have enough room
      setAmpCount(0);

// codaCount label
      add(codaCountLabel);
      codaCountLabel.setBorder(new EtchedBorder());
      setCodaCount(0);

    } // end of createPanel

public StatusPanel getStatusPanel (){
 return statusPanel;
}

/**
 * Set the value in the WFVCount label
 */
    public void setWFViewCount (int count)
    {
      viewCountLabel.setText(count + " Chnls");
    }
/**
 * Set the value in the phase count label
 */
    public void setPhaseCount (int count)
    {
      phaseCountLabel.setText(count + " Phases");
    }

 /**
 * Set the value in the amp count label
 */
    public void setAmpCount (int count)
    {
      ampCountLabel.setText(count + " Amps");
    }

 /**
 * Set the value in the doda count label
 */
    public void setCodaCount (int count)
    {
      codaCountLabel.setText(count + " Codas");
    }
/**
 * Set the value in the solution count label
 */
    public void setSolutionCount (int count) {
      solCountLabel.setText(count + " Sols");
    }

    public void setWfSourceText (String label, String tooltip) {
      wfSourceLabel.setText(label);
      wfSourceLabel.setToolTipText(tooltip);
    }
    public void setMvModelText (String label, String tooltip) {
      mvModelLabel.setText(label);
      mvModelLabel.setToolTipText(tooltip);
    }

    public void setDataSourceText (String label, String tooltip) {
      dataSourceLabel.setText(label);
      dataSourceLabel.setToolTipText(tooltip);
    }

    public JLabel getWfSourceLabel () {
      return wfSourceLabel;
    }
    public JLabel getMvModelLabel () {
      return mvModelLabel;
    }
    public JLabel getDataSourceLabel () {
      return dataSourceLabel;
    }
 } // end of class


