
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import org.trinet.jasi.*;

public class EventEditDialog extends CenteredDialog {

     Solution sol;
     DPmagnitude magPanel;

     JPanel mainPanel           = new JPanel();
     BorderLayout borderLayout1 = new BorderLayout();
     JPanel buttonPanel         = new JPanel();
     JButton cancelButton       = new JButton();
     JButton okButton           = new JButton();
     JTabbedPane tabPane        = new JTabbedPane();

     public EventEditDialog(Solution sol, Frame frame, String title, boolean modal) {

          super(frame, title, modal);

          this.sol = sol;

          try  {
               jbInit();
               pack();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

     public EventEditDialog(Solution sol) {
          this(sol, null, "Edit Solution Parameters", true);

     }

     void jbInit() throws Exception {
          mainPanel.setLayout(borderLayout1);
          cancelButton.setText("CANCEL");
          cancelButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    cancelButton_actionPerformed(e);
               }
          });
          okButton.setText("OK");
          okButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    okButton_actionPerformed(e);
               }
          });
          getContentPane().add(mainPanel);
          mainPanel.add(buttonPanel, BorderLayout.SOUTH);
          buttonPanel.add(okButton, null);
          buttonPanel.add(cancelButton, null);
          mainPanel.add(tabPane, BorderLayout.CENTER);

          // Mag editor is the only thing for now
          magPanel = new DPmagnitude(sol.magnitude);
          tabPane.add("Magnitude", magPanel);

	     pack();
	     centerDialog();

	     show();

     }

     void cancelButton_actionPerformed(ActionEvent e) {
        returnValue = JOptionPane.CANCEL_OPTION;
        this.setVisible(false);	    // dismiss dialog
     }

     void okButton_actionPerformed(ActionEvent e) {
        returnValue = JOptionPane.OK_OPTION;
        this.setVisible(false);	    // dismiss dialog
     }

     /** Returns the solution as modified by this dialog. */
     public Solution getSolution() {

//            sol.magnitude = magPanel.getMag();
            sol.setPreferredMagnitude(magPanel.getMag());

            return sol;
     }

/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String args[])
    {
	int evid = 0;

	if (args.length <= 0)	// no args
	{
	  System.out.println
	  ("Usage: EventEditDialog <evid>");
	  System.exit(0);

	}
	  Integer val = Integer.valueOf(args[0]);
	  evid = (int) val.intValue();

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection
	init.setWriteBackEnabled(true);

        Solution sol = Solution.create().getById(evid);

        if (sol == null ) {
          System.out.println ("Solution is null, evid = "+evid);
        } else {

        System.out.println (sol.toString());
        System.out.println (sol.magnitude.toDumpString());

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.pack();
        frame.setVisible(true);

        EventEditDialog dialog = new EventEditDialog(sol);

         if (dialog.getButtonStatus() == JOptionPane.OK_OPTION) {

            sol = dialog.getSolution();
         }

          System.out.println (sol.toString());
          System.out.println (sol.magnitude.toDumpString());

          Magnitude mag = sol.magnitude;

	System.out.println ("\n*Updating magnitude record.");
	System.out.println (mag.toDumpString());

     boolean status = true;
     try {
       status = mag.commit();
     } catch (JasiCommitException ex) {}

	System.out.println ("commit status = "+ status);


     // no DataSource commit




     } // end of if null...
    }
}

