
package org.trinet.jdbc.DataSources;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.DatabaseMetaData;
import org.trinet.jdbc.JDBConn;
import org.trinet.jasi.GenericDataSource;

/**
 * Define the default data source for all JASI classes.  This data source will
 * be used in static calls and in other methods when no data source is given.  */
public class JDBCDataSource extends GenericDataSource
{

    /** Set/reset connection.
     *  Lookup parameter data about a connection. Does not connect, assumes
     *  the connection is valid. */
    public boolean set (Connection connection)
    {
        if (connection != getConnection()) {
    source = DBASE;
    conn = connection;

  // parse connection info
    try {
      DatabaseMetaData md = conn.getMetaData() ;

      desc.setURL(md.getURL());
      desc.setDriver(md.getDriverName()) ;
      desc.setUsername(md.getUserName());
    } catch (SQLException ex)
      {
    System.err.println(ex);
    ex.printStackTrace();
    return false;
      }
        }
  return true;  // OK or no change
    }


    /** Set/reset the connection.
     *  Sets the static GenericDataSource to this object so calls to getXXX() return
     *  this static object. */
    public void set(String url,
           String driver,
           String username,
           String passwd)
    {
  source = DBASE;

  desc.setURL(url);
        desc.setDriver(driver);
  desc.setUsername(username);
  desc.setPassword(passwd);

        conn = getNewConnect();
    }
    /** Get a new connection to the default data source. This is usefull when
        you need multiple, simultaneous dbase connections. */
     public Connection getNewConnect () {
  JDBConn jc =  new JDBConn(desc.getURL(), desc.getDriver(),
          desc.getUsername(), desc.getPassword());
  return jc.conn;

    }

    public String getStatus () {

       return JDBConn.getStatus();
    }

    /** Return true if you cannot write results back to the data source */
    public boolean isReadOnly () {
  try {
         if (conn == null) return true;
   return conn.isReadOnly();
  } catch (SQLException ex)
      {
    System.err.println(ex);
    ex.printStackTrace();
      }

  // default (?)
  return true;
    }
    /**
     * Actually commit any transactions on this connect to the dbase.
     * If this is not called changes will not take effect.  */
    public void commit (Connection connection) {
  try {
      connection.commit();
  } catch (SQLException ex)
      {
    System.err.println(ex);
    ex.printStackTrace();
      }
    }
    /**
     * Rollback to the dbase. If this is not called changes will not take
     * effect.  */
    public void rollback () {
  try {
      conn.rollback();
  } catch (SQLException ex)
      {
    System.err.println(ex);
    ex.printStackTrace();
      }
    }


    /** Close the connection */
    public void close() {
  try {
      conn.close();
  } catch (SQLException ex)
      {
    System.err.println(ex);
    ex.printStackTrace();
      }
    }

}  /* end JDBCDataSource */