package org.trinet.jasi;

/**
 * jasiFactory.java
 *
 *
 * Created: Tue Oct 26 16:12:22 1999
 *
 * @author Doug Given
 * @version
 */

/**
 * Interface that contains the names of all schema types supported by jasi.
 * All jasi objects (abstract JasiObject) implement this interface to control
 * their factory methods. These values are for convenience. It is possible to
 * instantiat other concrete jasi implementation classes by passing the correct
 * suffix to the JasiObject.create() method. <p>
 *
 * Currently defined concrete classes:<p>
<table BORDER COLS=1 WIDTH="100%" >
<tr>
  <td>typeString</td> <td>suffix</td> <td>Comment</td>
</tr>
<tr>
  <td>TRINET</td> <td>TN</td> <td>TriNet NCDC schema</td>
</tr>
<tr>
  <td>EARTHWORM</td> <td>EW</td> <td>Earthworm schema</td>
</tr>
</table>
 *
 * @see: org.trinet.jasi.JasiObject
 */
public interface JasiFactory  {

    // Supported schema types and aliases

    /** Code for the TriNet (NCEDC v1.5) schema support jasi classes */
    public static final int TRINET     = 0;

    /** Code for the Earthworm schema support jasi classes */
    public static final int EARTHWORM  = 1;

    // Additional schemas would be added here

    /** Strings describing schema types. "TRINET", "EARTHWORM" */
    public static final String[] typeString = {"TRINET", "EARTHWORM"};

    /** Strings used as suffixes for concrete class names. "TN", "EW" */
    public static final String[] suffix = {"TN", "EW"};

    /** Map string schema names to int descriptions */
    public static final int[] typeValue = {TRINET, EARTHWORM};

} // jasiFactory
