package org.trinet.jasi;

//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

public class AmpList extends JasiReadingList {

     public AmpList() {
     }

    /** Return a subset of this list containing the Amplitudes that are from the
     * given Channel.
     * @deprecated: use getAssociated (Channel chan) */

    public AmpList getAssociatedWithChannel(Channel chan) {

	return getAssociated(chan);

    }
    /** Return a subset of this list containing the Amplitudes that are from the
     * given Channel. */
    public AmpList getAssociated (Channel chan) {

	AmpList newList = new AmpList();

	Amplitude amp[] = (Amplitude[]) getArray();
	for (int i = 0; i<amp.length; i++) {

	    if (chan.sameAs(amp[i].getChannelObj())) {
	       newList.add(amp[i]);
	    }
	}
	return newList;

    }

    /** Return a subset of this list containing the objects that are associated
     * with this solution. If Solution is set to null, unassociated objects will
     * be returned. Virtually deleted objects are never associated. */
    // Override getAssociated() in JasiReadingList because it return a JasiList object
    // and fucks up other code.
    public AmpList getAssociated(Solution sol) {

	AmpList newList = new AmpList();

	Amplitude amp[] = getArray();

	for (int i = 0; i<amp.length; i++) {
	    if (amp[i].sol == sol && !amp[i].isDeleted() ) {
            newList.add(amp[i]);
         }
	}
	return newList;
    }
    /**
 * Return the Amplitude nearest to this time. Returns null if there are none.
 */
    public Amplitude getNearestAmp(double time) {
      return (Amplitude) getNearestToTime(time);
    }
    /**
     * Convenience method that casts the object array returned by toArray()
     * as an array of type Amplitude.  */
    public Amplitude[] getArray() {
	return (Amplitude[]) toArray(new Amplitude[0]);
    }

    /**
     * Return an array of amps that are not zero weighted.
     *  */
    public Amplitude[] getGood() {

        AmpList newList = new AmpList();

        Amplitude amp[] = getArray();

        for (int i = 0; i<amp.length; i++) {
            if (amp[i].getWeight() > 0.0 && !amp[i].isDeleted() ) {
            newList.add(amp[i]);
         }
        }
	return newList.getArray();
    }

/**
 * Return the amp nearest to this time that matches this Channel.  Returns
null if there are none.  */
    public Amplitude getNearestAmp(double time, Channel chan) {

      return (Amplitude) getNearestToTime(time, chan);
    /*
	if (isEmpty()) return null;

	Amplitude amp[] = (Amplitude[]) getArray();

	Amplitude nearest = amp[0];
	double diff0 = Math.abs(nearest.getTime() - time);
	double diff;

	for (int i = 0; i<amp.length; ++i)	// inc at start
	{
	    if (!amp[i].isDeleted()) {
		if (chan.equalsIgnoreCase(amp[i].getChannel())) {

		    diff = Math.abs(amp[i].getTime() - time);

		    if (diff < diff0) {
			diff0 = diff;
			nearest = amp[i];
		    }
		}
	    }
	}

	return nearest;
*/
    }
    /** Return a count of how many channels
    * are represented in this list that also have a weight > 0.
    * A "station" is a unique "net", "sta". A station may have multiple channels.
    * This may give a different answer than getStationCount() because it only counts
    * "used" stations. */
    public int getChannelUsedCount () {

         if (isEmpty()) return 0;

         int count = 0;
	    Amplitude amp[] = (Amplitude[]) getArray();

         // for each entry, scan forward in list & only count if no repeats ahead
	    for (int i = 0; i<size(); i++) {
	          if ( amp[i].getWeight() > 0.0 ) count++;
         }
         return count;
    }
    /** Return a count of how many unique
    * stations are represented in this list that also have a weight > 0.
    * A "station" is a unique "net", "sta". A station may have multiple channels.
    * This may give a different answer than getStationCount() because it only counts
    * "used" stations.
    * @See: Channelable.getStationCount() */
    /* Does not require that the list be ordered in any particular way. */
    public int getStationUsedCount () {

         if (isEmpty()) return 0;

         int count = size();
	    Amplitude amp[] = (Amplitude[]) getArray();

         // for each entry, scan forward in list & only count if no repeats ahead
	    //for (int i = 0; i<size()-1; i++) {
	    for (int i = 0; i<size(); i++) {
         if ( amp[i].getWeight() == 0.0 ) {
                count--;
             } else {
               for (int k = i+1; k<size(); k++) {
	            if ( amp[i].getChannelObj().sameStationAs(amp[k].getChannelObj()) &&
                    ( amp[k].getWeight() > 0.0 ) ) {
                   count--;
                   break;
                 }
               }
             }
         }
         return count;
    }
 /*
   	    for (int i = 0; i<size()-1; i++) {
             for (int k = i+1; k<size(); k++) {
	          if ( ch[i].getChannelObj().sameStationAs(ch[k].getChannelObj()) ) {
                  count--;
                  break;
               }
             }
         }
 */
    /** Return true if the list has amps. */
    public boolean hasAmps() {
      return !isEmpty();
    }

    /**
     * Dump list, for debugging */
    public String dumpToString() {

	Amplitude amp[] = (Amplitude[]) getArray();

     String str = "";

	for (int i = 0; i<amp.length; i++) {
     // weed out deleted amps
         if (!amp[i].isDeleted())
         	    str += amp[i].toString() + "\n";
	}

     return str;
    }

    /**
     * Dump list, for debugging */
    public void dump() {
	    System.out.println (dumpToString());
    }
    /** Return a string with a neat listing of this reading list. */
    public String toNeatString () {

	  Amplitude amp[] = new Amplitude[this.size()];
	  this.toArray(amp);

       if (amp.length == 0) return "No readings.";

       String str = amp[0].getNeatStringHeader() + "\n";

	  for (int i=0; i<amp.length; i++) {

	    str += amp[i].toNeatString() + "\n";
	  }
       return str;
    }
}
