C******************************** KSIC *******************************
      FUNCTION KSIC (X1,Y1,X2,Y2)
C--COMPUTES THE SIGNED CROSSING NUMBER FOR THE KLAS FUNCTION

C--IF BOTH POINTS ARE ON THE SAME SIDE OF THE X AXIS, RETURN 0
      IF (Y1*Y2 .GT. 0.) GOTO 60

      S=X1*Y2-X2*Y1
C--CHECK IF SEGMENT CROSSES THRU ORIGIN
      IF (S.EQ.0. .AND. X1*X2 .LE. 0.) THEN
        KSIC=4
        RETURN
      END IF

C--CHECK FOR COMPLETE CROSSING
      IF (Y1*Y2 .LT. 0.) GOTO 30

C--ONE END OF SEGMENT TOUCHES X AXIS - WHICH END?
      IF (Y2.EQ.0.) GOTO 20
C--SINCE Y1=0, CHECK IF SEGMENT TOUCHES +X AXIS
      IF (X1.GT.0.) GOTO 60
C--UPWARD OR DOWNWARD?
      IF (Y2.GT.0.) GOTO 70
      GOTO 80

C--SINCE Y2=0, CHECK IF SEGMENT TOUCHES +X AXIS
20    IF (Y1.EQ.0. .OR. X2.GT.0.) GOTO 60
C--UPWARD OR DOWNWARD?
      IF (Y1.GT.0.) GOTO 80
      GOTO 70

C--COMPLETE CROSSING OF -X AXIS? BREAK INTO CASES ACCORDING TO DIRECTION
30    IF (Y1.GT.0.) GOTO 40

C--HERE IS THE CASE OF Y1 < 0 < Y2
      IF (S.GE.0.) GOTO 60
C--WE HAVE AN UPWARD CROSSING
      KSIC=2
      RETURN

C--HERE IS THE CASE OF Y1 > 0 > Y2
40    IF (S.LE.0.) GOTO 60
C--WE HAVE A DOWNWARD CROSSING
      KSIC=-2
      RETURN

C--THERE IS NO CROSSING
60    KSIC=0
      RETURN

C--THERE IS AN UPWARD HALF CROSSING
70    KSIC=1
      RETURN

C--THERE IS A DOWNWARD HALF CROSSING
80    KSIC=-1
      RETURN
      END
