      SUBROUTINE HYXMC
C--CALLED FROM HYCMD TO INITIALLY READ FILE OF STATION DUR MAG CORRECTIONS AND
C  THEIR EXPIRATION DATES.
      INCLUDE 'common.inc'
      CHARACTER STN*5,SNET*2,SCOMP*3, SLOC*2, CTYPE*1
      DIMENSION XMC(6),IXEXP(6),ITEXP(6),IYEARI(6)
      KOUNT=0

      IF (JSTA.EQ.0) THEN
        WRITE (6,1001)
1001    FORMAT (' *** ERROR: YOU CANT READ XMAG CORRECTIONS BEFORE',
     2  ' READING THE STATION FILE')
        IRES=-39
        RETURN
      END IF

C--OPTIONALLY SET ALL WEIGHTS TO ZERO IF WE WANT ONLY STAS W/ KNOWN CORRECTIONS
      IF (.NOT.LNOXMC) THEN
        DO J=1,JSTA
          JXWT(J)=0
        END DO
      END IF

C--OPEN THE STATION XMAG CORRECTION FILE
      CALL OPENR (13,XMCFIL,'F',IOS)
      IF (IOS.NE.0) THEN
C--ERROR FOR NON-EXISTENT FILE
        WRITE (6,1010)
1010    FORMAT 
     2  (' *** ERROR: STATION XMAG CORRECTION FILE DOES NOT EXIST')
        IRES=-40
        RETURN
      END IF

C--LOOP TO READ STATION XMAG CORRECTIONS
5     IF (L2000) THEN
        READ (13,1020,END=80) STN, SNET, SLOC, SCOMP, CTYPE, 
     2  (XMC(I),IYEARI(I),ITEXP(I),I=1,6)
1020    FORMAT (A5,1X, A2,A2, A3,1X, A1,1X, 6(F5.2,1X,I4,I6,1X))

      ELSE
        READ (13,1000,END=80) STN, SNET, SCOMP, CTYPE,
     2  (XMC(I),IYEARI(I),ITEXP(I),I=1,6)
1000    FORMAT (A5,1X, A2,2X, A3,1X, A1,1X, 6(F5.2,1X,I2,I6,3X))
        SLOC='  '
      END IF

C--SEARCH STATION LIST IN MEMORY FOR A MATCH (ALL LETTERS MUST MATCH,
C  UNLIKE STATION DELAYS)
      DO J=1,JSTA
        IF (STN(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2  SNET(1:NETLET) .EQ. JNET(J)(1:NETLET) .AND.
     3  (SLOC(1:NSLOC2) .EQ. JSLOC(J)(1:NSLOC2) .OR.
     3  SLOC(1:NSLOC2) .EQ. JSLOC2(J)(1:NSLOC2)) .AND.
     4  SCOMP(1:NCOMP) .EQ. JCOMP3(J)(1:NCOMP)) THEN

C--GIVE STATION FULL WEIGHT IF WEIGHT IS CONTINGENT ON BEING IN FILE
          IF (.NOT.LNOXMC) JXWT(J)=10

C--MAKE SURE IYEARI IS THE FULL 4-DIGIT YEAR
C--TRUNCATE YEAR TO 2146, THE LARGEST STORABLE IN I*4, STORE WHOLE STATE
          DO I=1,6
            IF (IYEARI(I).LT.100 .AND. IYEARI(I).GT.0) 
     2      IYEARI(I)=IYEARI(I)+ICENT
            IF (IYEARI(I).GT.2146) THEN
              WRITE (6,1200) STN, SNET, SCOMP, IYEARI(I)
1200          FORMAT ('*** XMC EXPIRATION YEAR TOO LARGE,',
     2        ' RESET TO 2146:'/1X,A5,1X,A2,1X,A3,1X,I4)
              IYEARI(I)=2146
            END IF
            IXEXP(I)=IYEARI(I)*1000000 +ITEXP(I)
          END DO

C--IF THE TARGET DATE IS 0, JUST TAKE THE FIRST CORRECTION & EXPIRATION DATE
          IF (IXDATE.EQ.0) THEN
            I=1
          ELSE
C--SEARCH FOR THE FIRST EXPIRATION DATE AFTER THE TARGET DATE
            DO I=1,6
              IF (IXEXP(I).EQ.0 .OR. IXEXP(I).GT.IXDATE) GOTO 10
            END DO
            IXEXP(6)=0
          END IF
C--STORE THE CORRECTION & ITS EXPIRATION DATE
10        JXEXP(J)=IXEXP(I)
C  ADD 5 TO CORRECTION TO GIVE IT ZERO WEIGHT
          IF (XMC(I).GT.2.45) THEN
            JXWT(J)=0
            XMC(I)=XMC(I)-5.
          ELSE
            JXWT(J)=10
          END IF
          JXCOR(J)=NINT(XMC(I)*100.)

C--GET TYPE IF FIELD IS NON-BLANK
          IF (CTYPE.NE.' ') THEN
            READ (CTYPE,'(I1)',ERR=75) ITYPE
            JTYPE(J)=ITYPE
            GOTO 77
75          WRITE (6,1075) STN, SNET, SCOMP, CTYPE
1075        FORMAT ('*** BAD INST TYPE IN XMC FILE: ',
     2      A5,1X,A2,1X,A3,1X, A1)
          END IF
77        KOUNT=KOUNT+1
C          GOTO 5  !COMMENT OUT TO STORE DATA FOR ALL CHANNELS THAT APPLY $
        END IF
      END DO
      GOTO 5

C--END OF FILE
80    CLOSE (13)
      WRITE (6,1002) KOUNT
1002  FORMAT (I6,' STATION XMAG CORRECTIONS SET')
      RETURN

      END
