      SUBROUTINE HYCAL
C--CALLED FROM HYCMD TO INITIALLY READ FILE OF STATION CAL FACTORS AND
C  THEIR EXPIRATION DATES.
      INCLUDE 'common.inc'
      CHARACTER STN*5, SNET*2, SCOMP*3, SLOC*2
      DIMENSION RCAL(7),IAEXP(7),ITEXP(7),IYEARI(7)
      KOUNT=0

      IF (JSTA.EQ.0) THEN
        WRITE (6,1001)
1001    FORMAT (' *** ERROR: YOU CANT READ CAL FACTORS BEFORE',
     2  ' READING THE STATION FILE')
          IRES=-35
        RETURN
      END IF

C--OPEN THE STATION CAL FACTOR FILE
      CALL OPENR (13,CALFIL,'F',IOS)
      IF (IOS.NE.0) GOTO 90

C--LOOP TO READ STATION CAL FACTORS
5     IF (L2000) THEN
        READ (13,1020,END=80) STN, SNET, SLOC, SCOMP,
     2  (RCAL(I),IYEARI(I),ITEXP(I),I=1,7)
1020    FORMAT (A5,1X, A2,A2, A3,1X, 7(F7.3,1X,I4,I6,1X))

      ELSE
        READ (13,1000,END=80) STN, SNET, SCOMP,
     2  (RCAL(I),IYEARI(I),ITEXP(I),I=1,7)
1000    FORMAT (A5,1X, A2,2X, A3,1X, 7(F7.2,1X,I2,I6,1X))
        SLOC='  '
      END IF

C--SEARCH STATION LIST IN MEMORY FOR A MATCH
      DO J=1,JSTA
        IF (STN(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2  SNET(1:NETLET) .EQ. JNET(J)(1:NETLET) .AND.
     3  (SLOC(1:NSLOC2) .EQ. JSLOC(J)(1:NSLOC2) .OR.
     3  SLOC(1:NSLOC2) .EQ. JSLOC2(J)(1:NSLOC2)) .AND.
     4  SCOMP(1:NCOMP) .EQ. JCOMP3(J)(1:NCOMP)) THEN

C--MAKE SURE IYEARI IS THE FULL 4-DIGIT YEAR
C--TRUNCATE YEAR TO 2146, THE LARGEST STORABLE IN I*4, STORE WHOLE STATE
          DO I=1,7
            IF (IYEARI(I).LT.100 .AND. IYEARI(I).GT.0) 
     2      IYEARI(I)=IYEARI(I)+ICENT
            IF (IYEARI(I).GT.2146) THEN
              WRITE (6,1200) STN, SNET, SCOMP, IYEARI(I)
1200          FORMAT ('*** CAL EXPIRATION YEAR TOO LARGE,',
     2        ' RESET TO 2146:'/1X,A5,1X,A2,1X,A3,1X,I4)
              IYEARI(I)=2146
            END IF
            IAEXP(I)=IYEARI(I)*1000000 +ITEXP(I)
          END DO

C--IF THE TARGET DATE IS 0, JUST TAKE THE FIRST CAL & EXPIRATION DATE
          IF (ICDATE.EQ.0) THEN
            I=1
          ELSE

C--SEARCH FOR THE FIRST EXPIRATION DATE AFTER THE TARGET DATE
            DO I=1,7
              IF (IAEXP(I).EQ.0 .OR. IAEXP(I).GT.ICDATE) GOTO 10
            END DO
            IAEXP(7)=0
          END IF

C--STORE THE CAL FACTOR & ITS EXPIRATION DATE
10        JCEXP(J)=IAEXP(I)
          JCAL(J)=RCAL(I)*1000.
          KOUNT=KOUNT+1
C          GOTO 5  !COMMENT OUT TO STORE DATA FOR ALL CHANNELS THAT APPLY
        END IF
      END DO
      GOTO 5

C--END OF CAL FACTOR FILE
80    CLOSE (13)
      WRITE (6,1002) KOUNT
1002  FORMAT (I6,' STATION CAL FACTORS SET')
      RETURN

C--ERROR FOR NON-EXISTENT FILE
90    WRITE (6,1010)
1010  FORMAT (' *** ERROR: STATION CAL FACTOR FILE DOES NOT EXIST')
      IRES=-36
      RETURN
      END
