/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *    $Id: ewdb_verylocaloci.h,v 1.1 2001/04/06 18:22:33 davidk Exp $
 *
 *    Revision history:
 *     $Log: ewdb_verylocaloci.h,v $
 *     Revision 1.1  2001/04/06 18:22:33  davidk
 *     Initial revision
 *
 *     Revision 1.2  2001/02/21 07:26:03  davidk
 *     removed extern declaration for oci_func_tab as it was unneccessary.
 *
 *     Revision 1.1  1999/11/09 18:38:26  lucky
 *     Initial revision
 *
 *
 */

  
/*
 *  localoci.h   
 *  
 *  Does all the basic Oracle OCI includes required
 *
 *  Also contains some useful definitions to use with OCI 7.3
 *  (Not everything is nicely defined in the Oracle header files)
 *                                       -Lynn Dietz
 *  
 * NOTE:  When you need to test the VALUE of a return code from an
 *        OCI function, always use the rc field of the Cda_Def structure
 *        instead of the actual returned value. The rc value will  
 *        always be positive (it's an unsigned 2-byte int in OCI 7.3).
 *
 *        The actual return value (which is the same as the
 *        outdated v2_rc field of the Cda_Def structure) may have 
 *        a different sign or value than the rc field and could 
 *        cause one to become very confused.  LDD
 *
 */

#ifndef LOCALOCI_H
#define LOCALOCI_H

/* Basic Oracle OCI includes: 
 ****************************/
#include <oratypes.h>
#include <ocidfn.h>
#ifdef __STDC__       /* if ANSI C compiler */
#include <ociapr.h>
#else
#include <ocikpr.h>
#endif

/* Useful local definitions start here: */

/* Oracle DataType Codes
 * internal/external datatype codes 
 **********************************/
#define VARCHAR2_TYPE         1   /* char[n], n<=2000                  */
#define NUMBER_TYPE           2   /* unsigned char[21]                 */
#define INT_TYPE              3   /* signed char,short,int, or long    */
#define FLOAT_TYPE            4   /* float, double                     */
#define STRING_TYPE           5   /* char[n+1] (null-terminated-string)*/
#define ROWID_TYPE           11   /* char[n]                           */
#define DATE_TYPE            12   /* char[7]                           */
#define LONGVARRAW_TYPE      24   /* unsigned char[n+ilen]             */
#define UNSIGNED_TYPE        68   /* unsigned integers                 */
#define CHAR_TYPE            96   /* fixed-length char[n] n<=255       */

/* Oracle OCI oparse flags 
 *************************/
#define  NATIVE                     1
#define  VERSION_7                  2
#define  OCI_NTS                   -1   /* null-terminated string */
#define  OCI_IGNORED_FIELD         -1
#define  OCI_MORE_FETCH_PIECES   3130
#define  OCI_MORE_INSERT_PIECES  3129
#define  OCI_NO_MORE_DATA        1403   /* got all data */
#define  OCI_NULL_COLUMN         1405   /* fetched a null column */
#define  OCI_TRUNCATED_COLUMN    1406   /* truncated a column */
#define  OCI_DEFER_FULL_PARSE       1
#define  OCI_NODEFER_FULL_PARSE     0
#define  OCI_NATIVE_BEHAVIOR        1  /* expect native behavior of the version you're connected to */
#define  OCI_VERSION_7              2  /* expect behavior of Oracle version7 */

/* Possible "indicator variable" values 
   ("indp" argument of obndrv,obndrn)
 **************************************/
#define  OCI_VALID_DATA             0
#define  OCI_NULL_DATA             -1

/* Arguments for oexfet
 **********************/
#define  CANCEL_CURSOR    1  /* cancel cursor (same as ocan) after fetch   */
#define  KEEP_CURSOR      0  /* keep cursor active, do more fetches w/ofen */  

/* Oracle return codes to check for on ofetch,oexfet,ofen
 ********************************************************/
#define  OCI_SUCCESS           0   /* no errors                            */
#define  OCI_NO_DATA_FOUND  1403   /* no more rows were selected           */
#define  OCI_NULL_COLUMN    1405   /* null item retrieved for a column     */
#define  OCI_TRUNCATED      1406   /* item fetched was truncated           */
#define  OCI_INVALID_CONV   1454   /* invalid conversion requested         */
#define  OCI_REALOVERFLOW   1456   /* item would overflow a floating-point */
                                   /* number on this machine               */
#define  OCI_UNSUPPORTED    3115   /* unsupported datatype                 */


#endif  /* LOCALOCI_H */

