#
# rcv_ew configuration file
#
# RCV under Earthworm is started by startstop, and given the command line 
#     found in startstop.d.  That's where RCV get's its customary command 
#     line arguments. 
# This file is read by the "user_proc" routines, which determine RCV's 
#     identity to Earthworm.
#
 MyModuleId       MOD_RCV_NSN7   # module id for this export,
 RingName         WAVE_RING    # transport ring to use for input/output,
 HeartBeatInt     90           # Heartbeat interval in seconds (Earthworm internal)
 LogFile          1            # If 0, don't write logfile at all,
 MaxSamplePerMsg  500          # #data samples in largest message we'll ever create
 PacketLatency    0            # #packets to buffer before shipping (to handle rollbacks)
# Debug    # uncomment to write debug messages

# Monitor the time since the last packet received for each sta/comp/net.
#  if MaxSilence  > 0, rcv_ew will issue a message to statmgr when it has not
#                      seen a packet for MaxSilence minutes.  If it has issued
#                      such a message, it will also issue another message when it
#                      starts receiving data for the SCN again.
#  if MaxSilence <= 0, rcv_ew will not monitor the time since last packet.
#
 MaxSilence 1440    # number of minutes to wait before complaining that
                    # no new data is being received for a given SCN

# List each sta/comp/net that you expect from Golden in a "AcceptSCN" command.
#     If rcv_ew sees an SCN which is not listed here, it will be ignored.
#     On each line after the SCN, list a pinnumber to use for this SCN.

#          site comp net pinno
#          ---- ---- --- -----
AcceptSCN  WVOR BHZ  US  5001
AcceptSCN  WVOR BHN  US  5043
AcceptSCN  WVOR BHE  US  5044
AcceptSCN  PLCA BHZ  GT  5007
AcceptSCN  PLCA BHN  GT  5075
AcceptSCN  PLCA BHE  GT  5076
AcceptSCN  BDFB BHZ  GT  5008
AcceptSCN  BDFB BHN  GT  5067
AcceptSCN  BDFB BHE  GT  5068
AcceptSCN  GUMO BHZ  IU  5010
AcceptSCN  PET  BHZ  IU  5011
AcceptSCN  PET  BHN  IU  5078
AcceptSCN  PET  BHE  IU  5079
AcceptSCN  YSS  BHZ  IU  5012
AcceptSCN  YSS  BHN  IU  5080
AcceptSCN  YSS  BHE  IU  5081
AcceptSCN  MA2  BHZ  IU  5013
AcceptSCN  ARU  BHZ  II  5014
AcceptSCN  INCN BHZ  IU  5015
AcceptSCN  INCN BHN  IU  5082
AcceptSCN  INCN BHE  IU  5083
AcceptSCN  TATO BHZ  IU  5016
AcceptSCN  TATO BHN  IU  5084
AcceptSCN  TATO BHE  IU  5104
AcceptSCN  COR  BHZ  US  5017
AcceptSCN  TUC  BHZ  US  5022
AcceptSCN  DWPF BHZ  US  5103
AcceptSCN  DWPF BHN  US  5063
AcceptSCN  DWPF BHE  US  5064
AcceptSCN  CBKS BHN  US  5059
AcceptSCN  CBKS BHE  US  5060
AcceptSCN  CBKS BHZ  US  5023
AcceptSCN  ANMO BHZ  IU  5025
AcceptSCN  NEW  BHZ  US  5028
AcceptSCN  JFWS BHZ  US  5029
AcceptSCN  JFWS BHN  US  5068
AcceptSCN  JFWS BHE  US  5069
AcceptSCN  WVT  BHZ  US  5030
AcceptSCN  WVT  BHE  US  5070
AcceptSCN  WVT  BHN  US  5071
AcceptSCN  LTX  BHZ  US  5031
AcceptSCN  LTX  BHN  US  5061
AcceptSCN  LTX  BHE  US  5062
AcceptSCN  SSPA BHZ  US  5003
AcceptSCN  SSPA BHN  US  5045
AcceptSCN  SSPA BHE  US  5046
AcceptSCN  OCWA BHZ  US  5027
AcceptSCN  OCWA BHN  US  5050
AcceptSCN  OCWA BHE  US  5051
AcceptSCN  OCWA HLZ  US  5026
AcceptSCN  OCWA HLE  US  5027
AcceptSCN  OCWA HLN  US  5028
AcceptSCN  HLID BHZ  US  5026
AcceptSCN  BW06 BHZ  US  5024
AcceptSCN  BW06 BHN  US  5057
AcceptSCN  BW06 BHE  US  5058
AcceptSCN  TPNV BHZ  US  5002
AcceptSCN  TPNV BHN  US  5052
AcceptSCN  TPNV BHE  US  5053
AcceptSCN  PAS  BHZ  IU  5033
AcceptSCN  SNCC BHZ  TS  5019
AcceptSCN  LPAZ BHZ  GT  5006
AcceptSCN  LPAZ BHN  GT  5065
AcceptSCN  LPAZ BHE  GT  5066
AcceptSCN  SBA  BHZ  IU  5009
AcceptSCN  SBA  BHN  IU  5092
AcceptSCN  SBA  BHE  IU  5093
AcceptSCN  HRV  BHZ  US  5040
AcceptSCN  HRV  BHN  US  5041
AcceptSCN  HRV  BHE  US  5042
AcceptSCN  BLA  BHZ  US  5047
AcceptSCN  BLA  BHN  US  5048
AcceptSCN  BLA  BHE  US  5049
AcceptSCN  VTV  BHZ  TS  5054
AcceptSCN  VTV  BHN  TS  5055
AcceptSCN  VTV  BHE  TS  5056
AcceptSCN  CPUP BHZ  GT  5069
AcceptSCN  CPUP BHN  GT  5070
AcceptSCN  CPUP BHE  GT  5071
AcceptSCN  LVC  BHZ  IU  5072
AcceptSCN  LVC  BHN  IU  5073
AcceptSCN  LVC  BHE  IU  5074
AcceptSCN  NNA  BHZ  II  5077
AcceptSCN  SNZO BHZ  IU  5085
AcceptSCN  SNZO BHN  IU  5086
AcceptSCN  SNZO BHE  IU  5087
AcceptSCN  VNDA BHZ  GT  5089
AcceptSCN  VNDA BHN  GT  5090
AcceptSCN  VNDA BHE  GT  5091
AcceptSCN  BJT  BHZ  IC  5094
AcceptSCN  OXF  BHZ  US  8001
AcceptSCN  OXF  BHE  US  8002
AcceptSCN  OXF  BHN  US  8003
AcceptSCN  MIAR BHZ  US  8004
AcceptSCN  MIAR BHE  US  8005
AcceptSCN  MIAR BHN  US  8006
AcceptSCN  CTAO BHZ  IU  8007
AcceptSCN  LBNH BHZ  US  8008
AcceptSCN  AAM  BHZ  US  8009
AcceptSCN  BINY BHZ  US  8010
AcceptSCN  EYMN BHZ  US  8011
AcceptSCN  EYMN BHN  US  8012
AcceptSCN  EYMN BHE  US  8013
AcceptSCN  BINY BHN  US  8014
AcceptSCN  BINY BHE  US  8015
AcceptSCN  LBNH BHE  US  8016
AcceptSCN  LBNH BHN  US  8017
AcceptSCN  AAM  BHE  US  8018
AcceptSCN  AAM  BHN  US  8019
AcceptSCN  HAWA BHZ  US  8020
AcceptSCN  HAWA BHE  US  8021
AcceptSCN  HAWA BHN  US  8022
AcceptSCN  HAWA HLZ  US  8023
AcceptSCN  HAWA HLE  US  8024
AcceptSCN  HAWA HLN  US  8025
AcceptSCN  HLID BHE  US  8030
AcceptSCN  HLID BHN  US  8031
AcceptSCN  NEW  BHE  US  8032
AcceptSCN  NEW  BHN  US  8033
AcceptSCN  LKWY BHZ  US  8034
AcceptSCN  LKWY BHN  US  8035
AcceptSCN  LKWY BHE  US  8036
AcceptSCN  AHID BHZ  US  8037
AcceptSCN  AHID BHN  US  8038
AcceptSCN  AHID BHE  US  8039
AcceptSCN  RSSD BHZ  US  8040
AcceptSCN  RSSD BHN  US  8041
AcceptSCN  RSSD BHE  US  8042
AcceptSCN  ISCO BHZ  US  8045
AcceptSCN  WUAZ BHZ  US  8046
AcceptSCN  WMOK BHZ  US  8047
AcceptSCN  LSCT BHZ  US  8048
AcceptSCN  LSCT BHN  US  8049
AcceptSCN  LSCT BHE  US  8050
AcceptSCN  GWDE BHZ  US  8051
AcceptSCN  GWDE BHN  US  8052
AcceptSCN  GWDE BHE  US  8053
AcceptSCN  NCB  BHZ  US  8056
AcceptSCN  NCB  BHN  US  8057
AcceptSCN  NCB  BHE  US  8058
AcceptSCN  CEH  BHZ  US  8059
AcceptSCN  CEH  BHN  US  8060
AcceptSCN  CEH  BHE  US  8061
AcceptSCN  HWUT BHZ  US  8062
AcceptSCN  HWUT BHN  US  8063
AcceptSCN  HWUT BHE  US  8064
AcceptSCN  MCWV BHZ  US  8065
AcceptSCN  MCWV BHN  US  8066
AcceptSCN  MCWV BHE  US  8067
AcceptSCN  MYNC BHZ  US  8072
AcceptSCN  MYNC BHE  US  8073
AcceptSCN  MYNC BHN  US  8074
AcceptSCN  BOZ  BHZ  US  8075
AcceptSCN  BOZ  BHE  US  8076
AcceptSCN  BOZ  BHN  US  8077
AcceptSCN  JCT  BHZ  US  8078
AcceptSCN  JCT  BHE  US  8079
AcceptSCN  JCT  BHN  US  8080
AcceptSCN  HKT  BHZ  US  8081
AcceptSCN  HKT  BHE  US  8082
AcceptSCN  HKT  BHN  US  8083
AcceptSCN  WMOK BHE  US  8084
AcceptSCN  WMOK BHN  US  8085
AcceptSCN  ANMO BHE  IU  8086
AcceptSCN  ANMO BHN  IU  8087
AcceptSCN  GOGA BHZ  US  8088
AcceptSCN  GOGA BHE  US  8089
AcceptSCN  GOGA BHN  US  8090
AcceptSCN  MVU  BHZ  LB  8091
AcceptSCN  MVU  BHE  LB  8092
AcceptSCN  MVU  BHN  LB  8093
AcceptSCN  WCI  BHZ  US  8094
AcceptSCN  WCI  BHE  US  8095
AcceptSCN  WCI  BHN  US  8096
AcceptSCN  DUG  BHZ  US  8097
AcceptSCN  DUG  BHE  US  8098
AcceptSCN  DUG  BHN  US  8099
AcceptSCN  ELK  BHZ  US  8200
AcceptSCN  ELK  BHN  US  8201
AcceptSCN  ELK  BHE  US  8202
AcceptSCN  MNV  BHZ  US  8203
AcceptSCN  MNV  BHN  US  8204
AcceptSCN  MNV  BHE  US  8205
AcceptSCN  TPH  BHZ  LB  8205
AcceptSCN  TPH  BHN  LB  8207
AcceptSCN  TPH  BHE  LB  8208
AcceptSCN  DAC  BHZ  LB  8209
AcceptSCN  DAC  BHN  LB  8210
AcceptSCN  DAC  BHE  LB  8211
AcceptSCN  BMN  BHZ  LB  8212
AcceptSCN  BMN  BHN  LB  8213
AcceptSCN  BMN  BHE  LB  8214
AcceptSCN  BOSA BHZ  GT  8215
AcceptSCN  BOSA BHN  GT  8216
AcceptSCN  BOSA BHE  GT  8217
AcceptSCN  CCM  BHZ  US  8218
AcceptSCN  CCM  BHN  US  8219
AcceptSCN  CCM  BHE  US  8220
AcceptSCN  CTU  BHZ  UU  8221
AcceptSCN  CTU  BHN  UU  8222
AcceptSCN  CTU  BHE  UU  8223
AcceptSCN  DBIC BHZ  GT  8224
AcceptSCN  DBIC BHN  GT  8225
AcceptSCN  DBIC BHE  GT  8226
AcceptSCN  ESK  BHZ  II  8227
AcceptSCN  ESK  BHN  II  8228
AcceptSCN  ESK  BHE  II  8229
AcceptSCN  GNI  BHZ  IU  8230
AcceptSCN  GNI  BHN  IU  8231
AcceptSCN  GNI  BHE  IU  8232
AcceptSCN  HIA  BHZ  IC  8233
AcceptSCN  HIA  BHN  IC  8234
AcceptSCN  HIA  BHE  IC  8235
AcceptSCN  ISA  BHZ  US  8236
AcceptSCN  ISA  BHN  US  8237
AcceptSCN  ISA  BHE  US  8238
AcceptSCN  KIV  BHZ  II  8239
AcceptSCN  KIV  BHN  II  8240
AcceptSCN  KIV  BHE  II  8241
AcceptSCN  KONO BHZ  IU  8242
AcceptSCN  KONO BHN  IU  8243
AcceptSCN  KONO BHE  IU  8244
AcceptSCN  LBTB BHZ  GT  8245
AcceptSCN  LBTB BHN  GT  8246
AcceptSCN  LBTB BHE  GT  8247
AcceptSCN  MTPC BHZ  CI  8248
AcceptSCN  MTPC BHN  CI  8249
AcceptSCN  MTPC BHE  CI  8250
AcceptSCN  OBN  BHZ  II  8251
AcceptSCN  OBN  BHN  II  8252
AcceptSCN  OBN  BHE  II  8253
AcceptSCN  PAHR BHZ  NN  8254
AcceptSCN  PAHR BHN  NN  8255
AcceptSCN  PAHR BHE  NN  8256
AcceptSCN  ULN  BHZ  IU  8257
AcceptSCN  ULN  BHN  IU  8258
AcceptSCN  ULN  BHE  IU  8259
AcceptSCN  WCN  BHZ  NN  8260
AcceptSCN  WCN  BHN  NN  8261
AcceptSCN  WCN  BHE  NN  8262
AcceptSCN  YAK  BHZ  IU  8263
AcceptSCN  YAK  BHN  IU  8264
AcceptSCN  YAK  BHE  IU  8265
AcceptSCN  KNB  BHZ  US  8266
AcceptSCN  KNB  BHN  US  8267
AcceptSCN  KNB  BHE  US  8268
AcceptSCN  PLAL BHZ  NM  8269
AcceptSCN  PLAL BHN  NM  8270
AcceptSCN  PLAL BHE  NM  8271
AcceptSCN  YSNY BHZ  US  8272
AcceptSCN  YSNY BHN  US  8273
AcceptSCN  YSNY BHE  US  8274
AcceptSCN  LPIG BHZ  MX  8275
AcceptSCN  LPIG BHN  MX  8276
AcceptSCN  LPIG BHE  MX  8277
AcceptSCN  TLY  BHZ  II  8278
AcceptSCN  TLY  BHN  II  8279
AcceptSCN  TLY  BHE  II  8280
AcceptSCN  PAYG BHZ  IU  8281
AcceptSCN  PAYG BHN  IU  8282
AcceptSCN  PAYG BHE  IU  8283
AcceptSCN  HOPS BHZ  BK  8284
AcceptSCN  YBH  BHZ  BK  8285
AcceptSCN  TIXI BHZ  IU  8286
AcceptSCN  POHA BHZ  IU  8287
AcceptSCN  POHA BHN  IU  8288
AcceptSCN  POHA BHE  IU  8289
AcceptSCN  WVL BHZ  NE  8291
AcceptSCN  PQI BHZ  NE  8292
AcceptSCN  PFO BHZ  II  8294
AcceptSCN  SUR BHZ  II  8295
AcceptSCN  TAU BHZ  II  8296
AcceptSCN  WDC BHZ  US  8297
AcceptSCN  COLA BHZ IU  8298
AcceptSCN  UTMT BHZ NM  8299
AcceptSCN  UTMT BHE NM  8300
AcceptSCN  UTMT BHN NM  8301
AcceptSCN  SLM BHZ NM  8302
AcceptSCN  SLM BHE NM  8303
AcceptSCN  SLM BHN NM  8304
AcceptSCN  BLO BHZ NM  8305
AcceptSCN  BLO BHE NM  8306
AcceptSCN  BLO BHN NM  8307
AcceptSCN  WES BHZ NE  8308
AcceptSCN  WES BHE NE  8309
AcceptSCN  WES BHN NE  8310
AcceptSCN  HNH BHZ NE  8311
AcceptSCN  HNH BHE NE  8312
AcceptSCN  HNH BHN NE  8313
AcceptSCN  COR  BHN  US  8314
AcceptSCN  COR  BHE  US  8315
AcceptSCN  WVL BHE  NE  8316
AcceptSCN  WVL BHN  NE  8317
AcceptSCN  PQI BHE  NE  8318
AcceptSCN  PQI BHN  NE  8319
AcceptSCN  MOD BHZ  BK  8293
AcceptSCN  ISCO BHE  US  8294
AcceptSCN  ISCO BHN  US  8295
AcceptSCN  WUAZ BHE  US  8296
AcceptSCN  WUAZ BHN  US  8297
AcceptSCN  SPA BHZ  IU  8398
AcceptSCN  SPA BHN  IU  8399
AcceptSCN  SPA BHE  IU  8400
AcceptSCN  SJG BHZ  IU  8401
AcceptSCN  SRU BHZ  UU  8402
AcceptSCN  YMR BHZ  WY  8403
AcceptSCN  SJG BHE  IU  8404
AcceptSCN  SJG BHN  IU  8405
#AcceptSCN SWET BHZ SE   8406
AcceptSCN ULM BHZ ??    8407
AcceptSCN AAK BHZ II    8408
AcceptSCN AAK BHE II    8409
AcceptSCN AAK BHN II    8410
AcceptSCN ACSO BHZ US    8411
AcceptSCN ACSO BHE US    8412
AcceptSCN ACSO BHN US    8413
AcceptSCN TKM2 BHZ ??    8414
AcceptSCN KWAJ BHZ II    8415
AcceptSCN KAPI BHZ II    8416
AcceptSCN WVL LHZ NE    8417
AcceptSCN WVL LHE NE    8418
AcceptSCN WVL LHN NE    8419
AcceptSCN  WES LHZ NE  8420
AcceptSCN  WES LHE NE  8421
AcceptSCN  WES LHN NE  8422
AcceptSCN  HNH LHZ NE  8423
AcceptSCN  HNH LHE NE  8424
AcceptSCN  HNH LHN NE  8425
AcceptSCN  PQI LHZ NE  8426
AcceptSCN  PQI LHE NE  8427
AcceptSCN  PQI LHN NE  8428
AcceptSCN  BRYW BHZ  NE  8429
AcceptSCN  BRYW BHE  NE  8430
AcceptSCN  BRYW BHN  NE  8431
AcceptSCN  EMMW BHZ  NE  8432
AcceptSCN  EMMW BHE  NE  8433
AcceptSCN  EMMW BHN  NE  8434
AcceptSCN  BRYW LHZ  NE  8435
AcceptSCN  BRYW LHE  NE  8436
AcceptSCN  BRYW LHN  NE  8437
AcceptSCN  EMMW LHZ  NE  8438
AcceptSCN  EMMW LHE  NE  8439
AcceptSCN  EMMW LHN  NE  8440
AcceptSCN  KBS  BHZ  IU  8441
AcceptSCN  KBS  BHE  IU  8442
AcceptSCN  KBS  BHN  IU  8443
AcceptSCN  NWAO BHZ  IU  8444
AcceptSCN  NWAO BHE  IU  8445
AcceptSCN  NWAO BHN  IU  8446
AcceptSCN  RCBR BHZ  IU  8447
AcceptSCN  RCBR BHE  IU  8448
AcceptSCN  RCBR BHN  IU  8449
AcceptSCN  CBN BHZ  US  8450
AcceptSCN  CBN BHE  US  8451
AcceptSCN  CBN BHN  US  8452
AcceptSCN  COCO BHE II 8453
AcceptSCN  COCO BHN II 8454
AcceptSCN  COCO BHZ II 8455
AcceptSCN  NHSC BHE US 7459
AcceptSCN  NHSC BHN US 7460
AcceptSCN  NHSC BHZ US 7461
AcceptSCN  LRAL BHE US 7462
AcceptSCN  LRAL BHN US 7463
AcceptSCN  LRAL BHZ US 7464
AcceptSCN  SDCO BHE US 7465
AcceptSCN  SDCO BHN US 7466
AcceptSCN  SDCO BHZ US 7467
###Added by Lynda for Stu of PTWC 7/17/02
AcceptSCN OTAV BHZ IU 7468
AcceptSCN FFC BHZ II 7469
AcceptSCN MAJO BHZ IU  7470
AcceptSCN KMBO BHZ IU 7471
AcceptSCN LSZ BHZ IU 7472
AcceptSCN MDJ BHZ IC 7473
AcceptSCN LSA BHZ IC 7474
AcceptSCN ENH BHZ IC 7475
AcceptSCN TRQA BHZ IU 7477
AcceptSCN MSO BHZ  US 7478
AcceptSCN MSO BHN  US 7479
AcceptSCN MSO BHE  US 7480
AcceptSCN PFO BHZ  II  7481
AcceptSCN LSA BHZ  IU  7482
AcceptSCN HUMO BHZ BK 7483 
AcceptSCN HUMO BHN BK 7484 
AcceptSCN HUMO BHE BK 7485 
AcceptSCN MBWA BHZ IU 7486 
AcceptSCN BILL BHZ IU 7487
AcceptSCN BBSR BHZ IU 7488
AcceptSCN RPN BHZ  II 7489
AcceptSCN KWAJ BHZ II 7490
