package org.trinet.web;

import java.text.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import org.trinet.jdbc.*;
import org.trinet.jasi.*;
import org.trinet.util.TimeSpan;

import Acme.JPM.Encoders.GifEncoder;

import org.trinet.waveserver.rt.WaveClient;

/**
 * Gif SnapGif of the first 'n' channels with phase picks.
 * The file defaults to <ID>.gif
 */
public class SnapGif extends SnapShot
{

    public static String gifFile;

    static boolean showIt = false;
    //    static boolean showIt = true;
    static boolean debug = true;
    //static boolean debug = false;

    public static void main (String args[])
    {
	//	long evid = 9570828;	// Hector EQ (yikes!)
	long evid = 0;

	if (args.length < 1)	// no args
	{
	  System.out.println ("Usage: SnapGif <evid> [ntraces] [max_secs] [waveServer-file] [out-file]  [dbase-host] [dbase-name]");
	  System.out.println ("           defaults:  ["+ntraces+"] ["+maxSecs+
			      "] [none] [<evid>.gif] ");
	  System.exit(-1);

	}

	// event ID
	Long l = Long.valueOf(args[0]);
	evid = (long) l.longValue();

	// # of traces
	if (args.length > 1) {
	  Integer val = Integer.valueOf(args[1]);
	  ntraces = (int) val.intValue();
	}

	// max. seconds to plot
	if (args.length > 2) {
	  Integer val = Integer.valueOf(args[2]);
	  maxSecs = (int) val.intValue();
	}

	// get data from waveServer?
	if (args.length > 3) {

	   waveServerFile = args[3];

	   // if wave server file is "" read from local files
	   if (!waveServerFile.equals("local")) {

	       System.out.println ("Get time series from waveServer: file = "+
				   waveServerFile);

	       WaveClient waveClient = null;

	       try {
		   // Make a WaveClient

		   System.out.println ("Creating WaveClient using: "+waveServerFile);

		   waveClient = new WaveClient(waveServerFile); // property file name

		   int nservers = waveClient.numberOfServers();
		   if (nservers <= 0) {
		       System.err.println("getDataFromWaveServer Error:"+
					  " no data servers specified in input file: " +
					  waveServerFile);
		       System.exit(-2);
		   }

	       }
	       catch (Exception ex) {
		   System.err.println(ex.toString());
		   ex.printStackTrace();
	       }

	       if (waveClient != null) Waveform.setWaveSource (waveClient);

	   }  // end of "if (!waveServerFile.equals(""))"

	} // end of "if (args.length > 3)"

	// destination .gif file
	gifFile = evid + ".gif";		//default
	if (args.length > 4) {
	    gifFile = args[4];
	}

	host = defaulthost;	// default
	if (args.length > 5) {
	    host = args[5];
	}

	dbasename = host+"db";	// default
	if (args.length > 6) {
	    dbasename = args[6];
	}
// -------------------------------------------------------

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource(host, dbasename);  // make connection

	// Makes the .gif file, returns the grapical component in case you want
	// to display it below
	Component view = makeGif (evid, ntraces, maxSecs, gifFile);


// make a frame
	if (showIt) {

	    JFrame frame = new JFrame("SnapGif of "+evid);

	    frame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {System.exit(-3);}
	    });

	    frame.getContentPane().add( view );	    // add scroller to frame

	    frame.pack();

	    frame.setVisible(true);

	}

	// Return codes:
	if (view == null) {
	    System.err.println ("exit status = -1");
	    System.exit(-1);	// failure
	} else {
	    System.err.println ("exit status = 0");
	    System.exit(0);	// success
	}
    }

    // //////////////////////////////////////////////////////////////////

    /**
     *
     */
    public static Component makeGif (long id, int ntraces, int maxSecs, String outFile) {
//	Component view = makeViewWithPhases (id, ntraces, maxSecs);

	//	System.out.println ("new makegif ");

	// must make instance because makeViewWithPhases() is not static
	SnapShot snapShot =  new SnapShot();
	//	System.out.println ("calling makeViewWithPhases... ");
	Component view = snapShot.makeViewWithPhases (id, ntraces, maxSecs);
	//Component view = snapShot.makeView(id, ntraces, maxSecs);

	encodeGifFile (view, outFile);
	return view;

    }

    /**
     *
     */
    public static boolean encodeGifFile (Component view, String gifFile) {

	if (view == null) return false;

	try {
	    // component must be in a frame for this to work
	    JFrame frame =  new JFrame();
	    frame.getContentPane().add( view );	    // add scroller to frame
	    frame.pack();

	    // Create an image (it will be blank)
	    if (debug) System.out.println ("making image...");
	    Image image = view.createImage(view.getWidth(), view.getHeight());

	    // get the graphics context of the image
	    if (debug) System.out.println ("getting graphics object...");
	    Graphics g = image.getGraphics();

	    // copy the frame into the image's graphics context
	    if (debug) System.out.println ("printing graphics object...");
	    view.print(g);

	    // open the output file
	    if (debug) System.out.println ("opening file...");
	    File file = new File(gifFile);
 	    FileOutputStream out = new FileOutputStream(file);

	    // create the encoder
	    if (debug) System.out.println ("encoding...");
	    GifEncoder encoder = new GifEncoder (image, out);

	    // encode it
	    encoder.encode();

	    if (debug) System.out.println ("Flushing...");

	    out.flush();
	    if (debug) System.out.println ("Close file...");
	    out.close();

	} catch (FileNotFoundException exc) {
	    System.err.println ("File not found: " + gifFile);
	    return false;
	} catch (IOException exc) {
	    System.err.println ("IO error: "+ exc.toString());
	    return false;
	} catch (OutOfMemoryError err) {
	    System.err.println ("Out of memory error: "+ err.toString());
	    return false;
	}

	return true;
    }

} // end of class
