package org.trinet.util;

import java.util.*;
import java.io.PrintStream;
import org.trinet.util.Format;		// CoreJava printf-like Format class
/**
 * Do timestamping for application benchmarking. The "prefix" is just a string that is
 * printed before the elapse time when the print() is called.
 */
public class BenchMark 
{

       String prefix = "";
       long t0;
       Format df = new Format("%9.4f");

    // save some typing later
private static final PrintStream o = System.out;

/**
 * Create a BenchMark object with this string as the default printing prefix.
 * Sets starttime to now.
 */
public BenchMark (String str)
{
    prefix = str;
    t0 = System.currentTimeMillis();
}
/**
 * Create a BenchMark object with no default printing prefix.
 * Sets starttime to now.
 */
public BenchMark ()
{
    t0 = System.currentTimeMillis();
}

/**
 * Print the current benchmark time with the default string "prefix" if any.
 */
public void print ()
{
//    long msElapse = System.currentTimeMillis() - t0;
    o.println (prefix +  df.form(getSeconds()) + " sec");
}
/**
 * Print the current benchmark time with this string as the prefix.
 */
public void print (String str)
{
//    long msElapse = System.currentTimeMillis() - t0;
    o.println (str + df.form(getSeconds()) + " sec");
}
/**
 * Reset the time counter to now.
 */
public void reset()
{
    t0 = System.currentTimeMillis(); 
}

public long getMillis () {
  return System.currentTimeMillis() - t0;
}

public double getSeconds () {
  return (double) (getMillis()/1000.);
}

} // end of class
