package org.trinet.pcs;
import org.trinet.jasi.coda.*;
import org.trinet.util.magnitudeengines.*;

// NOTE: configure a MCA module properties file to desired attributes if not specified defaults to: MCA.properties
//       if a logfile is not specified PrintStream defaults to System.out for all text messages

public class McaProcessingController extends AbstractJasiProcessingController {

    public McaProcessingController() {}

    public McaProcessingController(String defaultGroupName, String defaultThreadName, String defaultStateName) {
        this(new ProcessControlIdentifier(defaultGroupName, defaultThreadName, defaultStateName), null, null);
    }

    public McaProcessingController(String defaultGroupName, String defaultThreadName, String defaultStateName,
                                   String propFileName, String logFileName) {
        this(new ProcessControlIdentifier(defaultGroupName, defaultThreadName, defaultStateName), propFileName, logFileName);
    }

    public McaProcessingController(ProcessControlIdentifier pcId, String propFileName, String logFileName) {
        super(pcId);
        MCA mca = MCA.createMCA(propFileName, logFileName);
        setConnection(mca.getDefaultConnection());
        setProcessingModule(mca);
        String prop = System.getProperty("mcaProcessorSleepMillis"); // get from a property resource?
        if (prop != null) setDefaultSleepTimeMillis(Integer.parseInt(prop));
    }

// see CodaSolutionProcessingModes, just coda, coda and mag ...
    public void setProcessingModuleMode(CodaSolutionProcessingMode processingMode) {
        super.setProcessingModuleMode(processingMode);
    }

// a hook for oracle db stored procedure implementation
    public static final int processPostedEvents(String groupName, String threadName, String stateName,
                                                            String propertyFileName, String logFileName) {
        return (new McaProcessingController(groupName,threadName,stateName,propertyFileName,logFileName)).processIds();
    }

// default test method should be moved to  a main application class user package?
    public static final void main(String [] args) {

        String logFileName      = "mcaPC.log";
        String stateName        = "MCA";
        String propertyFileName = "test.properties";
        String threadName       = "TEST";
        String groupName        = "TESTMCA";

        int nargs = args.length;
        if (nargs == 1 && args[0].equals("?")) {
            System.out.println("    args:  [logFile]  [state] [propFile]      [thread] [group]"); 
            System.out.println("defaults:  mcaPC.log  MCA     test.properties TEST     TESTMCA");
            return;
        }
        switch (nargs) {
            case 5 :
                groupName = args[4];
            case 4 :
                threadName = args[3];
            case 3 :
                propertyFileName = args[2];
            case 2:
                stateName = args[1];
            case 1:
                logFileName = args[0];
        }

        System.out.println("Processing events for: " + groupName + " " + threadName + " " + stateName);
        System.out.println("Using propertyfile: " + propertyFileName);
        System.out.println("       logFileName: " + logFileName);
	System.out.println(groupName + " " +  threadName + " " +  stateName);
        int result = McaProcessingController.processPostedEvents(groupName,threadName,stateName, propertyFileName,logFileName);

        System.out.println("\nMcaProcessingController.processEvents events processed: " + result);
        if (result == 0) System.out.println("McaProccessing Controller: Check for valid id state postings or rank BLOCKING.");
        else if (result < 0) System.out.println("McaProccessing Controller: Check state table for error.");
    }
}
