package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;

public class StatusFrame extends JFrame {

     JLabel textLabel = new JLabel();

     // make 0-100%
     JProgressBar progressBar = new JProgressBar(0, 100);
     JLabel graphicLabel = new JLabel();
     JPanel mainPanel = new JPanel();

     // default
     ImageIcon defIcon = new ImageIcon("E:/Images/Gifs/gearsAnim.gif");
    //     ImageIcon defIcon = null;

     public StatusFrame() {
          try  {
               jbInit();
          }
          catch(Exception e) {
               e.printStackTrace();
          }
     }

     public StatusFrame(String title, String text) {
       this ();
       set(title, text);
     }

     public StatusFrame(String title, String text, Icon icon) {
	 this();
          set (title, text, icon);
     }


     public void set(String title, String text, Icon icon) {
        setTitle(title);
        setText(text);
        setIcon(icon);
        setProgress(0);

        pack();
     }
     public void set(String title, String text) {
        setTitle(title);
        setText(text);
        setIcon(defIcon);
        setProgress(0);

        pack();
     }
/** Set the text in the text panel. */
     public void setText(String text) {
       textLabel.setText(text);
       pack();
     }

     public void setIcon (Icon icon) {

	 if (icon != null) graphicLabel.setIcon(icon);

//        graphicLabel = new JLabel(icon);
        pack();
     }

     public void setProgress (int percent) {
        progressBar.setValue(percent);
        progressBar.setString(percent+"%");
     }

     public void setProgress (double percent) {
        setProgress( (int) percent);
     }

// Create the object (built using JBuilder)
     private void jbInit() throws Exception {

          textLabel.setText("status text here");
          mainPanel.setLayout(new BorderLayout());
          mainPanel.setMinimumSize(new Dimension(200, 150));
          mainPanel.setPreferredSize(new Dimension(200, 150));

          graphicLabel.setHorizontalAlignment(SwingConstants.CENTER);
//          graphicLabel.setIcon(new ImageIcon(new java.net.URL("file:///e:/TPP/images/tsunami.gif")));
          mainPanel.add(graphicLabel, BorderLayout.CENTER);
          mainPanel.add(textLabel, BorderLayout.NORTH);
          mainPanel.add(progressBar, BorderLayout.SOUTH);
          progressBar.setStringPainted(true);

          this.getContentPane().add(mainPanel);

          centerDialog();
     }

/**
 * Center the dialog on the screen
 */
    protected void centerDialog() {
     Dimension screenSize = this.getToolkit().getScreenSize();
	Dimension size = this.getSize();
	screenSize.height = screenSize.height/2;
	screenSize.width = screenSize.width/2;
	size.height = size.height/2;
	size.width = size.width/2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	this.setLocation(x,y);
    }

///////////////////////////////////////////////////////////
     public static void main(String[] args) {
    //      ImageIcon defIcon = new ImageIcon ("images/swing-64.gif");

        ImageIcon defIcon = new ImageIcon("E:/Images/Gifs/gearsAnim.gif");

     /*   JLabel pic = new JLabel(defIcon);
        jpanel1.add(pic);
     */
          StatusFrame statusFrame =
	      //          new StatusFrame("Test frame", "Something's happening", defIcon);
          new StatusFrame("Test frame", "Something's happening");
  //        statusFrame.pack();
          statusFrame.setVisible(true);

          statusFrame.setProgress(43);

     }
}
