package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;

import org.trinet.jasi.*;
import org.trinet.util.gazetteer.*;

public class SolutionPanel extends JPanel {

    // must keep references to these so we can remove them as observers
    SolutionListComboBox solCombo = new SolutionListComboBox();
    EventTypeChooser typeChooser  = new EventTypeChooser();
    FixDepthButton fixDepthButton = new FixDepthButton();

    MasterView mv;
    static Jiggle jiggle;

    int axis = BoxLayout.X_AXIS;

    public SolutionPanel(Jiggle jig, int axis) {
        jiggle = jig;
        this.axis = axis;
        setMasterView(jiggle.mv);

    }
     /** Default to a horizontal box*/
     public SolutionPanel(Jiggle jig) {
        jiggle = jig;
        setMasterView(jiggle.mv);    // default to HorizontalBox
     }

     public void setMasterView (MasterView mv) {
        this.mv = mv;
        // must rebuild the component
        buildComponent(axis);
     }
    /**
    * Make/remake the guts of the SolutionPanel. It is a Box withing an JPanel.
    */
    public void buildComponent(int axis) {

       this.removeAll();

       Box box = new Box(axis);

       add(box);

       setBorder( new TitledBorder("Selected Solution") );

       // can't do the rest without a MasterView
/////
    if (mv == null || mv.solList.size() == 0) {
       setEnabled(false);
       return;
     }
/////
    if (mv == null) {
       setEnabled(false);
       return;
     }
     // remove any dangling references to old components in MVC model
     mv.solList.removeChangeListener(solCombo);
     mv.solList.removeChangeListener(typeChooser);
     mv.solList.removeChangeListener(fixDepthButton);

     if (mv.solList == null || mv.solList.size() == 0) {
       setEnabled(false);
       return;
     }

     // [EVENT]
	solCombo = new SolutionListComboBox (mv.solList);

	// [TYPE] set selected 'type' correctly
	typeChooser =
          new EventTypeChooser(mv.getSelectedSolution().getEventTypeString());
	typeChooser.addItemListener(new EventTypeComboHandler());

     // [FIX]
     fixDepthButton = new FixDepthButton(mv);
     fixDepthButton.addActionListener(new FixButtonHandler());

     // add these components as listeners to the SolutionList
     mv.solList.addChangeListener(solCombo);
     mv.solList.addChangeListener(typeChooser);
     mv.solList.addChangeListener(fixDepthButton);

     // clear contents
     box.removeAll();

     box.add(solCombo);
     box.add(Box.createHorizontalStrut(10));
     box.add(typeChooser);
     box.add(Box.createHorizontalStrut(10));
     box.add(fixDepthButton);

     }


/** Enable/disable components that only make sense when there's selected
event.  */
  public void setEnabled(boolean tf) {
    solCombo.setEnabled(tf);
    typeChooser.setEnabled(tf);
    fixDepthButton.setEnabled(tf);
  }

/**
* Handle changes to eventType made by the EventTypeChooser
*/
    class EventTypeComboHandler implements ItemListener {

	// this is the action taken when the event type is selected
      public void itemStateChanged(ItemEvent e) {

        Solution sol = mv.solList.getSelected();

        if (sol == null) return; // no solution

	JComboBox jc = (JComboBox) e.getSource();

	if ( jc.getSelectedItem() == null ) return;  // internal setSelected event

	String type =  (String) jc.getSelectedItem();

	// no change = no action
	if (type.equalsIgnoreCase(sol.getEventTypeString())) return;

	//X// set the type of the selected event
     sol.setEventType(type);

//	System.out.println ("Event type set to "+ type);
	//	System.out.println ("status = "+status+ "  type= "+type);

     // if its a QUARRY, ask for a comment but supply a default string of the form:
	// "BORON QUARRY, CA"
        if (type.equalsIgnoreCase("QUARRY")) {

          // fix depth at whatever, probably 0.0
          if (jiggle.props.getBoolean("fixQuarryDepth")) {     // fix quarries?
             sol.depth.setValue(jiggle.props.getDouble("quarryFixDepth"));
	     sol.depthFixed.setValue(true);
	     fixDepthButton.setSolution(sol);
          }

	     WhereIsEngine whereEngine =
              WhereIsEngine.CreateWhereIsEngine(jiggle.props.getProperty("WhereIsEngine"));

          // construct default comment
          LatLonZ latlonz = sol.getLatLonZ();
	     whereEngine.setReference(latlonz.getLat(), latlonz.getLon(), latlonz.getZ());
// Wrong type from DK, causing java.lang.ClassCastException
//       WhereSummaryItem wsi = (WhereSummaryItem)whereEngine.WhereSummaryType("Quarry");
//       String placeString = wsi.fromPlaceString(false);
             WhereSummary ws = (WhereSummary)whereEngine.WhereSummaryType("Quarry");
             String placeString = ws.fromPlaceString(false);

	     // must strip of " from " which the Where class always tacks on the place name
	     if (placeString.startsWith(" from")) placeString = placeString.substring(6);

//	     System.out.println (placeString);

	     SolutionPanel.this.jiggle.addComment(placeString);

     // if its not a LOCAL, ask for a comment but don't supply a default string
	   } else if (!type.equalsIgnoreCase("LOCAL")) {
	     SolutionPanel.this.jiggle.addComment();
        }

       // do this to force a change event to notify listners
       mv.solList.setSelected(sol);

      }

    }  // end of EventTypeComboHandler

 class FixButtonHandler implements ActionListener {
	public void actionPerformed (ActionEvent evt) {

          fixDepthButton.toggle();

     }
 }  // end of FixButtonHandler


     // ///////////////////////////////////////////////////
         public static void main(String s[]) {

         long evid = 9642013;

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
      	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
          });

        final Jiggle jig = new Jiggle();
        Solution sol = Solution.create();
        sol.setId(12345);

        jig.mv.addSolution(sol);
        jig.mv.solList.setSelected(sol);

        SolutionPanel solPanel = new SolutionPanel(jig);

        JButton btn = new JButton("Add New Event");
        btn.addActionListener (new ActionListener () {
          long evid = 100000;

     	public void actionPerformed (ActionEvent evt) {
            Solution solx = Solution.create();
            solx.setId(evid++);
            System.out.println("Added id = "+evid);
            jig.mv.addSolution(solx);
            jig.mv.solList.setSelected(solx);
          }

        });

        JButton btn2 = new JButton("Del Sel Event");
        btn2.addActionListener (new ActionListener () {
     	public void actionPerformed (ActionEvent evt) {
            Solution solx = jig.mv.getSelectedSolution();
            System.out.println("delete id = "+solx.id);
            jig.mv.solList.delete(solx);
          }

        });
         JPanel panel = new JPanel(new BorderLayout());

         panel.add(solPanel, BorderLayout.CENTER);
         JPanel buttonPanel = new JPanel();
         buttonPanel.add(btn);
         buttonPanel.add(btn2);
         panel.add(buttonPanel, BorderLayout.SOUTH);

         frame.getContentPane().add(panel);

        frame.pack();
        frame.setVisible(true);

    }

} // end of SolutionPanel
