package org.trinet.jasi;

/**
 * Rflag.java
 *
 *
 * Created: Thu Dec  9 14:24:45 1999
 *
 * @author Doug Given
 * @version
 */
import org.trinet.jdbc.datatypes.*;

/**
 * NCDN 'rflag' field object. The purpose is to map a char in the NCDC field to
 * an in enumeration; */

public class Rflag  {

    /** Data row status is not known */
    public static final int UNKNOWN   = 0;

    /** Data row is automatic and unreviewed */
    public static final int AUTOMATIC = 1;

    /** Data row was reviewed by a human*/
    //    public static final int REVIEWED  = 2;

    /** Data row was reviewed by a human  */
    public static final int HUMAN     = 2;

    /** Data row is final */
    public static final int FINAL     = 3;

    
    //    public Rflag() { }

    public static String toString(int val) {

	if (val == AUTOMATIC) return "A";
	//	if (val == REVIEWED)  return "H";
	if (val == HUMAN)     return "H";
	if (val == FINAL)     return "F";

	//	if (val == UNKNOWN)   return "";

	return "";
    }

    public static int toInt(String str) {
	if (str.equals("A")) return AUTOMATIC;
	if (str.equals("H")) return HUMAN;
	if (str.equals("F")) return FINAL;
	return 0;
    }  

    public static int toInt(DataObject obj) {

	return Rflag.toInt(obj.toString());

    }  

} // Rflag
