package org.trinet.jasi;

/** Static ChannelList that can be shared by modules without passing a reference.
*
* @see: ChannelList
*/
public class MasterChannelList {

     static  ChannelList chanList = null;

     private MasterChannelList() {
     }

     /** Set the shared ChannelList. */
     public static void set (ChannelList list) {

            chanList = list;
     }

     /** Returns 'true' if this list is null or empty. */
     public static boolean isEmpty() {

            if (chanList == null) return true;
            return chanList.isEmpty();
     }

     /** Return the shared ChannelList. */
     public static ChannelList get () {

            return chanList;
     }

     // main for testing

     /*
     public static void main(String[] args) {

            new DataSource();

            System.out.println("Reading channel list.");
            MasterChannelList.set(ChannelList.smartLoad());

            MasterChannelList.get().dump();
            System.out.println("Total channels = "+  MasterChannelList.get().size());
     }
     */
} 