package org.trinet.jasi;
import java.util.*;
import org.trinet.util.*;
// DK import org.trinet.jdbc.table.*;

public class ChannelDataList extends Object implements Cloneable {
/**
* Store in a hashmap keyed by the ChannelIdIF a set of valid dates ranges for the ChannelIdIF
* If an input Date lies within a DateRange (ondate offdate) of the set, cached data object is returned.
* Otherwise, object if a new ChannelData object can be created from the database it is added to the cache
* and returned. Returns null if the data is not recoverable.
* The cached ChannelData object's DateRange and ChannelId are used to compose the key that is mapped to the
* ChannelData object in the hashmap.
*/
    protected HashMap chanParmMap;
    protected HashMap chanDateMap;

/* need another method to input a preloaded hashmap e.g. McaCalibrationList which maps channelId to date range data table record.
      input map
      get value
      get value.dateRange
      get value.channelId
      addToChanDateMap(value.channelId value.d,teRange)
      addToChanParmMap(value)
         makeKey(value.channelId, value.dateRange;
*/
    protected ChannelDataIF lookUpInDataSource(ChannelDataIF cid, Date date) {
            ChannelDataIF chanData = cid.load(cid, date);
            if (chanData == null) return null;
            add(chanData);
            return chanData;
    }

    public boolean isEmpty() {
        return (chanDateMap == null || chanParmMap == null || chanDateMap.isEmpty() || chanParmMap.isEmpty());
    }

    protected void add(ChannelDataIF chanData) {
            if (chanDateMap == null) chanDateMap = new HashMap();

            DateRange dateRange = chanData.getDateRange();
            ChannelIdIF id = chanData.getChannelId();

            Set aDateRangeSet = (Set) chanDateMap.get(id);
            if (aDateRangeSet != null) {
                aDateRangeSet.add(dateRange);
            }
            else {
                aDateRangeSet = new HashSet();
                aDateRangeSet.add(dateRange);
                chanDateMap.put(id, aDateRangeSet);
            }

            if (chanParmMap == null) chanParmMap = new HashMap();
            chanParmMap.put(makeHashKey(id, dateRange), chanData);
    }

    public ChannelDataIF lookUp(ChannelDataIF cid, Date date) {
        ChannelDataIF chanData = lookUpInList(cid, date);
        return (chanData != null) ?  chanData : lookUpInDataSource(cid, date) ;
    }

    protected ChannelDataIF lookUpInList(ChannelDataIF cid, Date date) {

        if (chanDateMap == null) return null;

        Set aSet = (Set) chanDateMap.get(cid);
        if(aSet == null) return null;

        ChannelDataIF retVal = null;
        Iterator iter = aSet.iterator();
        while (iter.hasNext()) {
            DateRange dateRange = ((DateRange) iter.next());
            if (dateRange.contains(date)) {
                Integer key = makeHashKey(cid.getChannelId(), dateRange);  // combines dateRange with name into unique key object
                retVal =  (ChannelDataIF) chanParmMap.get(key);
                break;
            }
        }
        return retVal; // return cid; //??
    }

    private Integer makeHashKey(ChannelIdIF id, DateRange dateRange) {
        return new Integer( id.hashCode()+dateRange.hashCode() );
    }

    public boolean equals(Object object) {
        if (object == this) return true;
        if (object == null || object.getClass() != this.getClass()) return false;
        ChannelDataList list = (ChannelDataList) object;
        return ( chanDateMap.equals(list.chanDateMap) && chanParmMap.equals(list.chanParmMap) );
    }

    public Object clone() {
        ChannelDataList cdl = null;
        try {
            cdl = (ChannelDataList) super.clone();
            cdl.chanDateMap = (HashMap) this.chanDateMap.clone();
            cdl.chanParmMap = (HashMap) this.chanParmMap.clone();
        }
        catch(CloneNotSupportedException ex) {
             ex.printStackTrace();
        }
        return cdl;
    }

   public int hashCode() {
        return chanDateMap.hashCode() + chanParmMap.hashCode() ;
   }

}   // end of ChannelDataList class
