
/**
 * PassingScore.java
 *
 *
 * Created: Tue Feb  8 16:03:38 2000
 *
 * @author Doug Given
 * @version
 */

package org.trinet.eventmatch;
import java.sql.*;

    /**
     * Retreive the value of passingScore from the database. It is kept in a
     * table called: EventMatchPassingScore that has one column called
     * passingScore. <p>
     *
     * From SQL you would access it using: <br>
     * SQL> Select passingScore from EventMatchPassingScore;
     */
public class PassingScore  {
    
    
    private PassingScore() {
	
    }


    /**
     * Get the passing score from the database. It is kept in a table called:
     * EventMatchPassingScore that has one column called passingScore.
     */
public static double getPassingScore() {

    Connection conn = DbaseConnection.create();

    String sql = "Select passingScore from EventMatchPassingScore";

    ResultSet rs;

    double score = 0.0;

    try {

	Statement stmt = conn.createStatement();

	rs = stmt.executeQuery(sql);

	rs.next() ;
	score = rs.getDouble("passingScore");

	stmt.close();		//closes statement & resultset

      } catch (SQLException ex) {
	      ex.printStackTrace(System.out);
      }

      return score;
}
  public static void main (String args[]) {  

      System.out.println ("The passing score is "+ PassingScore.getPassingScore());
  }  
} // PassingScore
