package org.trinet.apps.other;

import java.util.*;
import org.trinet.jiggle.MasterView;

import org.trinet.util.gazetteer.LatLonZ;
import org.trinet.util.*;
import org.trinet.jasi.*;
import org.trinet.util.magnitudeengines.*;

public class MagFromWFs extends LocalMagnitudeEngine {

     public static void main (String args[])
    {

//     String host = "makalu";
     String host = "k2";

     EnvironmentInfo.setNetworkCode("CI");
  EnvironmentInfo.setApplicationName("MagFromWFs");
     EnvironmentInfo.setAutomatic(false);

  long evid = 0;

  if (args.length <= 0)	// no args
  {
    System.out.println ("Usage: java MagnitudeEngine <evid> [<dbase>])");
    System.exit(0);

  } else {

    Integer val = Integer.valueOf(args[0]);	    // convert arg String
    evid = (int) val.intValue();

    if (args.length > 1) host = args[1];	    // dbase

  }

        System.out.println ("Making connection...");
  DataSource dbs = new TestDataSource();

     if (dbs == null) {
       System.exit(0);
     }

  System.out.println (" Getting evid = "+evid);

  MasterView mv = new MasterView();

     // wave scanner will load them
  mv.setWaveFormLoadMode(MasterView.LoadNone);

  mv.defineByDataSource(evid);

  Solution sol = mv.getSelectedSolution();
/*
  System.out.println (" Getting amps for evid = "+evid);
  // Read amps for this event from the dbase
  //	ArrayList amp = (ArrayList)Amplitude.create().getBySolution(sol);
  //sol.magnitude.getAmps();
     String list[] = {"WAU" } ;   // get only W-A uncorrected amps
     sol.magnitude.addAmps(Amplitude.create().getByMagnitude(sol.magnitude, list));
*/
  System.out.println ("Amp count = " + sol.magnitude.getAmpCount());
     System.out.println ("Sta count = "+ sol.magnitude.ampList.getStationCount());

  System.out.println (" Original mag for: "+sol.toString());
  System.out.println (sol.magnitude.toDumpString()) ;
  System.out.println ("") ;
  System.out.println (sol.magnitude.ampList.toNeatString());
  System.out.println ("") ;

  // Calc SoCal mag.
  System.out.println (" Calculating mag (SoCalML) for: "+sol.toString());

/*
     SoCalML ml = new SoCalML();
     ml.setRequireCorrection(true);

  MagnitudeEngine magEng = new MagnitudeEngine(ml);

     Magnitude newMag = magEng.solveFromWaveforms(sol, mv.getWaveformList());
*/
  MagnitudeMethod ml = MagnitudeMethod.CreateMagnitudeMethod("org.trinet.util.magnitudeengines.SoCalML");
  ml.ConfigureMagnitudeMethod();

  MagnitudeEngine magEng = MagnitudeEngine.CreateMagnitudeEngine("org.trinet.util.magnitudeengines.LocalMagnitudeEngine");
  magEng.ConfigureMagnitudeEngine(ml);

  Magnitude newMag = magEng.solve(sol, mv.getWaveformList());

  System.out.println (sol.magnitude.toDumpString()) ;
  System.out.println ("") ;
  System.out.println (sol.magnitude.ampList.toNeatString());

  // Calc generic ML
/*
  System.out.println (" Calculating mag (generic) for: "+sol.toString());
     ML ml = new ML();
  magEng = new MagnitudeEngine(ml);

//     ml.setTrimResidual(1.0);
     //magEng.setMinSNR(1.2);

  magEng.solve(sol.magnitude);

  System.out.println (sol.magnitude.toDumpString()) ;
  System.out.println ("") ;
  System.out.println (sol.magnitude.ampList.toNeatString());
*/
     // commit the changes

//.//     sol.magnitude.commit();

  DataSource.close();

     System.exit(0);

    }

}