package org.trinet.util.graphics.task;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*; 

/**
  * Extends AbstractTaskMonitor panel so that task operations can be controlled 
  * by a button enabled component.
*/

public class TaskMonitorButtonBoxPanel extends AbstractTaskMonitorButtonBoxPanel {

/** Container for the buttons. */
    protected class ButtonBox extends Box {
        public JButton startButton;
        public JButton stopButton;
        ButtonBox(int axis) {
             super(axis);
        }
    }

    public TaskMonitorButtonBoxPanel(AbstractMonitorableTask task) {
        super(task);
    }

    protected void initPanelLayout() {
        setLayout(new BorderLayout());
        add(buttonControls, BorderLayout.NORTH);
        add((Component) progressMeter, BorderLayout.CENTER);
    }

/** Disables start button, enables stop button. */
    protected void disableButtonControlStart() {
        resetControlButtons(false);
    }
/** Disables stop button, enables start button. */
    protected void enableButtonControlStart() {
        resetControlButtons(true);
    }
    protected void resetControlButtons() {
        resetControlButtons(true);
    }
/**
  * Toggles start/stop button enabling.
  * Input true to enable start, disable stop; input false for the converse.
*/
    protected void resetControlButtons(boolean value) {
        if (buttonControls != null) {
            ButtonBox box = (ButtonBox) buttonControls;
            box.stopButton.setEnabled(!value);
            box.startButton.setEnabled(value);
        }
    }

/**
  * Returns a button containing component to control the
  * starting and stopping the task.
*/
    protected Container createControlButtonComponent() {
        final JButton startButton  = new JButton("Start");
        final JButton stopButton   = new JButton("Stop");

        startButton.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                startTask();
            }
        });
        stopButton.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                stopTask();
            }
        });
        stopButton.setEnabled(false);

        ButtonBox box = new ButtonBox(BoxLayout.X_AXIS);
        box.startButton = startButton;
        box.stopButton = stopButton;

        box.add(Box.createGlue());
        box.add(startButton);
        box.add(Box.createHorizontalStrut(10)); 
        box.add(stopButton);
        box.add(Box.createGlue());
        return box;
    }

/** Starts task, disables start button, enables stop button. */
    public void startTask() {
        super.startTask();
        disableButtonControlStart();
    }

/** Starts task, disables stop button, enables start button. */
    public void stopTask() {
        super.stopTask();
        enableButtonControlStart();
    }
}
