package org.trinet.util;
/**
 * General purpose range (pair) of double values
 * @deprectated Replaced by org.trint.util.DoubleRange.
 */
public class RangeDouble
{
    public double min;
    public double max;

    public RangeDouble (double mn, double mx)
    {
	set (mn, mx);
    }

/**
 * Set/reset the max/min values in the range
 */
    public void set (double mn, double mx)
    {
	min = mn;
	max = mx;

	// auto swap incase caller blew it

	if (min > max)
	{
	    double tmp = min;
	    min = max;	    //swap
	    max = tmp;
	}
    }

    public void include ( double val )
    {
	if (val < min) min = val;
	if (val > max) max = val;
    }

/**
 * Adjust current range to include range in argument
 */
    public void include (RangeDouble range)
    {
	if (range.min < min) min = range.min;
	if (range.max > max) max = range.max;
    }

    public boolean isIn (double val)
    {
	if (val >= min && val <= max) return true;
	return false;
    }

    public boolean isIn (RangeDouble range)
    {
	if (range.min >= min && range.max <= max) return true;
	return false;
    }

    public double size ()
    {
	return max - min;
    }

    public String toString() {
       return min + ", " + max;
    }

} // end of class
