package org.trinet.pcs;
public class ProcessingResult {
    // Errors
    public static final ProcessingResult FAILURE =
           new ProcessingResult("FAILURE", -1);
    public static final ProcessingResult UNKNOWN_PROCESSING_MODE =
           new ProcessingResult("UNKNOWN_PROCESSING_MODE", -5);
    public static final ProcessingResult NULL_INPUT =
           new ProcessingResult("NULL_INPUT", -10);
    public static final ProcessingResult INVALID_INPUT =
           new ProcessingResult("INVALID_INPUT", -20);
    public static final ProcessingResult INVALID_ID =
           new ProcessingResult("INVALID_ID", -30);
    public static final ProcessingResult INVALID_POSTING_RANK =
           new ProcessingResult("INVALID_POSTING_RANK", -40);
    public static final ProcessingResult DB_SQL_EXCEPTION =
           new ProcessingResult("DB_SQL_EXCEPTION", -50);
    public static final ProcessingResult MISSING_DB_DATA =
           new ProcessingResult("MISSING_DB_DATA", -200);
    public static final ProcessingResult INVALID_DATA =
           new ProcessingResult("INVALID_DATA", -210);
    public static final ProcessingResult UNKNOWN_ERROR_TYPE =
           new ProcessingResult("UNKNOWN_ERROR_TYPE", -9999);

    //Success
    public static final ProcessingResult INPUT_NOOP =
           new ProcessingResult("INPUT_NOOP", 0);
    public static final ProcessingResult NO_RESULTS_RETURNED =
           new ProcessingResult("NO_RESULTS_RETURNED", 0);
    public static final ProcessingResult UNIT_SUCCESS =
           new ProcessingResult("UNIT_SUCCESS", 1);

    private String description;
    private int id;    
    protected ProcessingResult(String description, int id) {
       this.description = description;
       this.id = id;
    }
    public int getIdCode() {
        return id;
    }
    public String getDescription() {
        return description;
    }
    public String toString() {
        return description + "=" + id;
    }
}
