package org.trinet.jdbc.table;
import org.trinet.jdbc.datatypes.*;
import java.sql.Connection;
/**
 * Class to access and manipulate the NCEDC parametric schema Remark table.
 */

public class Remark extends DataTableRow implements TableRowRemark {

/** Constructor uses static data members defined by the TableRowRemark interface to initialize the base class with 
* the parameters necessary to describe the schema table named by the interface String parameter DB_TABLE_NAME. 
* The class implements several convenience methods to provides class specific static arguments to the argument
* list of the DataTableRow base class methods. Base class methods are used to set or modify the values and states
* of the contained DataObjects. Because the base class uses a JDBC connection class (see org.trinet.jdbc.JDBConnect)
* to access the database containing the table described by this object, a connection object must be instantiated before
* using any of the database enabled methods of this class.
* Object states refering to data update, nullness, and mutability are inhereited from the DataTableRow base class
* implementation of the DataState interface. These state conditions are used to control the methods access to the
* object and its contained DataObjects, which also implement the DataState interface.
* The default constructor sets the default states to: setUpdate(false), setNull(true), setMutable(true), and
* setProcessing(NONE).
*/
    public Remark () {
        super(DB_TABLE_NAME, SEQUENCE_NAME, MAX_FIELDS, KEY_COLUMNS, FIELD_NAMES, FIELD_NULLS, FIELD_CLASS_IDS);
    }
    
    public Remark(Remark object) {
	this();
        for (int index = 0; index < MAX_FIELDS; index++) {
            fields.set(index, ((DataObject) object.fields.get(index)).clone());
        }
        this.valueUpdate = object.valueUpdate;
        this.valueNull = object.valueNull;
        this.valueMutable = object.valueMutable;
    }
    
/** Constructor invokes default constructor, then sets the default Connection object to the handle of the input Connection argument.
* The newly instantiated object state values are those of the default constructor.
*/
    public Remark(Connection conn) {
	this();
        setConnection(conn);
    }

/** Constructor invokes default constructor, then sets the column data members to the input values.
* The newly instantiated object state values are isUpdate() == true and isNull == false.
*/
    public Remark(long commid) {
	this();
        fields.set(COMMID, new DataLong(commid));
	valueUpdate = true;
	valueNull = false;
    }

/** Constructor invokes default constructor, then sets the column data members to the input values.
* The newly instantiated object state values are isUpdate() == true and isNull == false.
*/
    public Remark(long commid, long lineno) {
	this(commid);
        fields.set(LINENO, new DataLong(lineno));
    }

/** Constructor invokes default constructor, then sets the column data members to the input values.
* The newly instantiated object state values are isUpdate() == true and isNull == false.
*/
    public Remark(long commid, long lineno, String remark) {
	this(commid, lineno);
        fields.set(REMARK, new DataString(remark));
    }

/** Returns table row count.
*/
    public int getRowCount() {
	return ExecuteSQL.getRowCount(connDB, getTableName());
    }

/** Returns table row count corresponding to the specified input event id.
*/
    public int getRowCountByCommId(long commid) {
        String  whereString = "WHERE COMMID = " + commid ;
	return ExecuteSQL.getRowCount(connDB, getTableName(), "*", whereString);
    }

/** Returns an array of this class where each element contains the data from a single table row parsed from an SQL query
* for rows associated with the specified event id (commid). 
* A return value of null indicates no data or an error condition.
*/
    public Remark [] getRowsByCommId(long commid) {
        String  whereString = "WHERE COMMID = " + commid ;
	return (Remark []) getRowsEquals(whereString);
    }
   
/*
/** Deletes rows associated with the specified event id (commid).
* Returns number of rows deleted for specified id. A return value of -1 indicates an error condition.
    public static int deleteRowsByCommId(long commid) {
	String  whereString =
	  "WHERE COMMID = " + commid;
	return ExecuteSQL.deleteRowsEquals(connDB, getTableName(), whereString);
    }
*/

/** Returns the String value of the remark column field.
*/
    public String toStringRemark() {
	return getStringValue(REMARK);
    }
}
