package org.trinet.jasi.coda;
import org.trinet.jdbc.datatypes.*;
public class TimeAmp extends Object {
    DataDouble time;
    DataDouble amp;

    public TimeAmp(DataDouble time, DataDouble amp) {
      this.time = time;
      this.amp = amp;
    }

    public TimeAmp(double time, double amp) {
      this.time = new DataDouble(time);
      this.amp = new DataDouble(amp);
    }

    public String toString() {
       StringBuffer sb = new StringBuffer(48);
       sb.append(time.toStringSQL()).append(" ").append(amp.toStringSQL());
       return sb.toString();
    }

    public String toString(char delimiter) {
       StringBuffer sb = new StringBuffer(48);
       sb.append(time.toStringSQL()).append(delimiter).append(amp.toStringSQL());
       return sb.toString();
    }

    public double getTime() { return time.doubleValue();}
    public double getAmp() { return amp.doubleValue();}
}

