package org.trinet.jasi;

public class ProcessingState {

    /** Defines possible processing states:<p>
    *
    * '?'=unknown 'A'=automatic, 'H'=human, 'F'=final */

    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_AUTOMATIC = 1;
    public static final int STATE_HUMAN = 2;
    public static final int STATE_FINAL = 3;

    static final String tag[] = {"?", "A", "H", "F"};

    static final String label[] = {"unknown", "automatic", "human", "final"};

    public ProcessingState() {
    }

    public static String getLabel (int state) {
       return label[state];
    }

    public static String getTab (int state) {
       return tag[state];
    }

    public static String[] getLabelArray () {
       return label;
    }

    public static String[] getTagArray () {
       return tag;
    }

    // DK NEW ADDED  061002
    public static int getIndexOfLabel (String sLabel)
    {
      for(int i=0; i < label.length; i++)
        if(sLabel.compareTo(label[i]) == 0)
          return(i);
      // else
      return(-1);
    }

}