package org.trinet.apps;

import org.trinet.jiggle.*;
import java.io.*;
import java.util.*;
import java.text.*;
import java.lang.*;
import java.net.*;

import org.trinet.jdbc.*;	// Allan's package
import org.trinet.util.*;
import org.trinet.hypoinv.*;
import org.trinet.jasi.*;
import org.trinet.jdbc.datatypes.DataString;

public class Locate {

  static JiggleProperties props;
  static long evid;

    public static void main (String args[]) {

  // switch for debugging
//	boolean commitIt = false;
  boolean commitIt = true;

     String host = "makalu";

  long evid = 0;

  if (args.length <= 0)	// no args
  {
    System.out.println ("Usage: java org.trinet.jiggle.Locate <evid> [<dbase>])");
    System.exit(0);

  } else {

    Integer val = Integer.valueOf(args[0]);	    // convert arg String
    evid = (int) val.intValue();

    if (args.length > 1) host = args[1];	    // dbase

  }

        System.out.println ("Making connection...");
  DataSource init = new TestDataSource(host);  // make connection
  init.setWriteBackEnabled(true);

     //EnvironmentInfo.setNetworkCode('CI'));
  EnvironmentInfo.setApplicationName("Locate");
     EnvironmentInfo.setAutomatic(false);

     // Need loction server info, + net name
     props = new JiggleProperties("properties");

  DbaseConnectionDescription dbConn = props.getDbaseDescription();
  // The data source is static
//	DataSource ds = new DataSource(dbConn);

  String locEngAddr = props.getProperty("locationEngineAddress");
  int locEngPort    = props.getInt("locationEnginePort");

//     System.out.println ("Loading MasterChannelList...");
//     MasterChannelList.set(ChannelList.smartLoad());

     System.out.println ("Making MasterView for evid = "+evid);

  MasterView mv = new MasterView();	    // make MasterView
     mv.setWaveFormLoadMode(MasterView.LoadNone);
     mv.defineByDataSource(evid);

  Solution sol = mv.solList.getSelected();

     if (sol == null) {
        System.out.println ("No solution found for "+evid);
        System.exit(-1);
     }

  System.out.println ("--- Before location ------------------------------");
  System.out.println (sol.fullDump());
  System.out.println ("--------------------------------------------------");

  LocationEngine locEng = LocationEngine.CreateLocationEngine("org.trinet.jiggle.LocalEngineHypoInverse");
  locEng.setServer(locEngAddr, locEngPort);

// locate it
  boolean status = locEng.solve(sol);

  if (status) {
         if (!EnvironmentInfo.isAutomatic()) sol.processingState.setValue("H");
         sol.authority.setValue(EnvironmentInfo.getNetworkCode());
         sol.source.setValue(EnvironmentInfo.getApplicationName());
         sol.setEventType(EventTypeMap.LOCAL);

      System.out.println ("--- After Location -------------------------------");
      System.out.println (sol.fullDump());
      System.out.println ("--------------------------------------------------");
      //	sol.phaseList.dump();

         recalcMag(sol);

         // sets the flag but won't send alarms
         sol.setProcessingState(ProcessingState.STATE_FINAL);

      if (commitIt) {
    System.out.println ("Committing solution...");
    System.out.println ("Message = "+locEng.getMessage());

          try {
        sol.commit();
           System.out.println (sol.getCommitStatus());
          } catch (JasiCommitException ex) {
           System.out.println ("Commit error.");
          }

      } else {
    System.out.println ("NOT Committing solution...");
      }

  } else {

      System.out.println ("Solution failed.");
      System.out.println (locEng.getMessage());
  }

     locEng.disconnect();
  }

   static void recalcMag (Solution sol) {

      if (sol.magnitude == null ||
          sol.magnitude.isNull()) return;

 // should check method??
      if (sol.magnitude.isCodaMag()) {
         calcMC(sol);
      } else {
         calcML(sol);
      }
 }

/** Calculate the MC magnitude of this solution using the existing coda data.
Does NOT re-examine the waveforms. */
public static void calcMC (Solution sol) {

    if (sol.magnitude == null) return;	// no mag
    String configFile = props.getProperty("mcaConfigFile");
    ChannelList chanList =  MasterChannelList.get();
    // create on 1st use then reuse

    /***********    OLD Code
    JiggleMCA mcaMagEng = new JiggleMCA(configFile, chanList);

    Magnitude newMag = mcaMagEng.calcSummaryMag(sol);
    ***********/

    MagnitudeEngine mcaMagEng = MagnitudeEngine.CreateMagnitudeEngine("org.trinet.jasi.JiggleMCA");
    mcaMagEng.ConfigureMagnitudeEngine(MagnitudeEngine.ConfigurationSourceFile,
                                       configFile,null, chanList);
    Magnitude newMag = mcaMagEng.solve(sol);
    return;
}

/** Calculate the ML magnitude of this solution. Does NOT re-examine the waveforms. */
public static void calcML (Solution sol) {

    if (sol.magnitude == null) return;	// no mag

  MagnitudeMethod ml = MagnitudeMethod.CreateMagnitudeMethod("org.trinet.util.magnitudeengines.SoCalML");
  ml.ConfigureMagnitudeMethod();

  MagnitudeEngine magEng = MagnitudeEngine.CreateMagnitudeEngine("org.trinet.util.magnitudeengines.LocalMagnitudeEngine");
  magEng.ConfigureMagnitudeEngine(ml);

  Magnitude newMag = magEng.solve(sol.magnitude);



}

}  // end of class