package org.trinet.util.graphics.task;
import java.awt.*;
import java.beans.*;
import javax.swing.*; 

/**
  * Creates a JPanel containing a JOptionPane component
  * having "Start", "Stop" and "Cancel" button control
  * over the input AbstractMonitorableTask instance.
*/ 
public class TaskMonitorStartOptionPanel extends AbstractTaskMonitorOptionPanel {

    public TaskMonitorStartOptionPanel(AbstractMonitorableTask task) {
        super(task);
    }

/**
  * Returns a JOptionPane component containing the progress monitor.
  * Task thread is controlled using JOptionPane "Start", "Stop", options.
  * By default "Cancel" option will stop task processing,
  * then dispose parent container if it is a dialog frame.
  * @see #addButtonControlPropertyChangeListener(PropertyChangeListener)
 */
    protected JOptionPane createOptionPane() {
        String [] stringOptions = { "Start", "Stop", "Cancel"};
        final JOptionPane optionPane = 
            new JOptionPane( progressMeter,
                            JOptionPane.INFORMATION_MESSAGE,
                            JOptionPane.DEFAULT_OPTION,
                            null, stringOptions, stringOptions[0]);
        optionPane.addPropertyChangeListener(
            new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (isVisible() && (e.getSource() == optionPane)
                     && (prop.equals(JOptionPane.VALUE_PROPERTY) ||
                         prop.equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                        String value = (String) e.getNewValue();
                        if (value.equals("Stop")) {
                            stopTask();
                        }
                        else if (value.equals("Start")) {
                            startTask();    
                        }
                        else if (value.equals("Cancel")) {
                            if (isStopConfirmed()) {
                                doStopProcessing();    
                                disposeDialog();
                            }
                        }
                        else {
                            System.out.println("Option UNKNOWN: " + value);
                        }
                    }
                }
        });
        return optionPane;
    }
}
