//Title:        util                                            
//Version:      
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.util.graphics;

import java.awt.*;
import javax.swing.*;

import java.awt.event.*;

import org.trinet.jasi.EventSelectionProperties;
import org.trinet.util.*;

/**
Presents a centered, tabbed dialog to set values of EventSelectionProperties.
Note that this class modifies a private version of the EventSelectionProperties
that are passed as a parameter. It can't change the original directly. The caller
must call getEventSelectionProperties() to see the revised properties.
This should only be done if a call to getButtonStatus() returns
JOptionPane.OK_OPTION indicating the user wants to apply the new properties.
*/

public class EventSelectionDialog extends JDialog {

     JPanel mainPanel = new JPanel();

     JPanel  buttonPanel  = new JPanel();
     JButton cancelButton = new JButton();
     JButton okButton     = new JButton();
     JTabbedPane tabPane    = new JTabbedPane();
     JPanel  timeTabPanel   = new JPanel();
     JPanel  regionTabPanel = new JPanel();
     JPanel  otherTabPanel  = new JPanel();

     /** Time selection */
     EventSelectionTimePanel eventSelectionTimePanel;
     /** Event "flag" panel */
     EventSelectionFlagPanel flagPanel;

     // The local EventSelectionProperties
     EventSelectionProperties props;
     // a copy used by the flags panel
     EventSelectionProperties flagProps;

     /** Status for dialog when closed. */
     int returnValue = JOptionPane.CLOSED_OPTION;

     ButtonGroup buttonGroup = new ButtonGroup();

//     Box radioButtonBox = Box.createVerticalBox();;

     public EventSelectionDialog(Frame frame, String title, boolean modal,
                                       EventSelectionProperties eventProps) {
          super(frame, title, modal);

          // make a copy, so we can back out incase [CANCEL] is pressed
          props = eventProps;

          // this take a while, given user reassurance that its happening
          StatusFrame statusFrame =
             new StatusFrame("Working...", "Creating Dialog...", null, false);
             statusFrame.setVisible(true);
             
          try  {
               jbInit();
               pack();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          } finally {
               statusFrame.setVisible(false);
          }
     }

     public EventSelectionDialog(EventSelectionProperties eventProps) {
          this(null, "", true, eventProps);
     }

     /** Create the GUI */
     void jbInit() throws Exception {

          // cancel button
 //         radioButtonBox = Box.createVerticalBox();
          mainPanel.setLayout(new BorderLayout());
          cancelButton.setText("Cancel");
          cancelButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    cancelButton_actionPerformed(e);
               }
          });

          // OK button
          okButton.setText("OK");
          okButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    okButton_actionPerformed(e);
               }
          });


          timeTabPanel.setLayout(new BorderLayout());

          getContentPane().add(mainPanel);

          mainPanel.add(buttonPanel, BorderLayout.SOUTH);
          buttonPanel.add(okButton, null);
          buttonPanel.add(cancelButton, null);

          mainPanel.add(tabPane, BorderLayout.CENTER);

// time selection panel
          //eventSelectionTimePanel = new EventSelectionTimePanel(props);
          eventSelectionTimePanel = new EventSelectionTimePanel(
                           new EventSelectionProperties(props));

          tabPane.add(timeTabPanel, "Time Range");
          timeTabPanel.add(eventSelectionTimePanel, BorderLayout.CENTER);

          tabPane.add(regionTabPanel, "Region");
          regionTabPanel.add(new JLabel("Not yet implemented"));

          tabPane.add(otherTabPanel, "Other Attributes");

// flag panel
/*        // make a copy of the properties
          flagProps = new EventSelectionProperties(props);
          flagPanel = new EventSelectionFlagPanel(flagProps);
          otherTabPanel.add(flagPanel);
*/
          flagPanel = new EventSelectionFlagPanel(props);
          otherTabPanel.add(flagPanel);
     }

      /** Set the time span fo r the date range chooser*/
     public TimeSpan getTimeSpan() {
        return eventSelectionTimePanel.getTimeSpan();
     }

     /** Return the EventSelectionProperties */
     public EventSelectionProperties getEventSelectionProperties () {
            return props;
     }

 
/**
 * Pop dialog asking if preferences should be saved to a file.
 */
    void saveDialog() {

    //pop confirming  yes/no dialog:
           int yn = JOptionPane.showConfirmDialog(
                   null, "Save these properties to startup file?",
                   "Save Properties?",
                   JOptionPane.YES_NO_OPTION);

	    if (yn == JOptionPane.YES_OPTION) {
    		   props.saveProperties();
	    }
    }


      // [OK] button
     void okButton_actionPerformed(ActionEvent e) {

          returnValue = JOptionPane.OK_OPTION;

          // We have to "gather" the modified properties from the various panels
          // because the original is not modified when we pass it as a reference
          props = flagPanel.getProperties();

          props = eventSelectionTimePanel.updateTimeProperties(props);

          saveDialog();

          setVisible(false);
     }

     // [Cancel] button
     void cancelButton_actionPerformed(ActionEvent e) {
          returnValue = JOptionPane.CANCEL_OPTION;
          setVisible(false);
     }


     public int getButtonStatus () {
        return returnValue;
     }

     /** Override to center dialog on screen */
     public void setVisible (boolean tf) {

            if (tf) centerDialog();
            super.setVisible(tf);

     }
/**
 * Center the dialog on the screen
 */
   public void centerDialog() {
     Dimension screenSize = this.getToolkit().getScreenSize();
	Dimension size = this.getSize();
	screenSize.height = screenSize.height/2;
	screenSize.width = screenSize.width/2;
	size.height = size.height/2;
	size.width = size.width/2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	this.setLocation(x,y);
    }

 ///////
     public static void main(String s[]) {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
// Private properties
	   EventSelectionProperties props = new EventSelectionProperties("eventProperties");

        props.dumpProperties();

        EventSelectionDialog dialog =
                 new EventSelectionDialog(frame, "Event Selection", true, props);

        dialog.setVisible(true);

        System.out.println ("-- Event Selection Properties BEFORE --");

       props.dumpProperties();

       System.out.println ("-----------");

        if (dialog.getButtonStatus() == JOptionPane.OK_OPTION) {
           props = dialog.getEventSelectionProperties();
        }

       System.out.println ("-- Event Selection Properties AFTER --");

       props.dumpProperties();

       System.out.println ("-----------");

	   frame.setSize(200,30);	// this has no effect!
        frame.pack();
        frame.setVisible(true);

    }
}
