package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;
import java.sql.*;
import java.util.*;
/** Polymorphic type extension of WhereLine */
public class WhereFault extends WhereLine {
    public WhereFault() {
	super();
    }
    public WhereFault(Connection conn) {
	super(conn);
    }
    public WhereFault(Connection conn, Geoidal reference) {
	super(conn, reference);
    }
    public WhereFault(Geoidal reference) {
	super(reference);
    }
    public WhereFault(double lat, double lon, double z) {
	super(lat, lon, z);
    }

/** Return String name of the geographic entity represented by this class */
    public String getLineTypeName() {
	return "Fault";
    }

/** Returns Vector of WhereItems constructed using gazetteer database data for town type. */
    protected Vector getDatabaseData() {

/*
	String sql = "SELECT * FROM GAZETTEERLINE, GAZETTEERFAULT WHERE GAZETTEERLINE.TYPE = " +
		GazetteerType.FAULT.getCode() +
		" AND GAZETTEERLINE.GAZID = GAZETTEERFAULT.GAZID (+)";
*/
	String sql = "SELECT NAME, LINE, FORMAT, POINTS FROM GAZETTEERLINE";
	return super.getDatabaseData(sql);
    }
}
