package org.trinet.util;

/**
* Provide math functions left out of Java like LOG10 !
 */

public class MathTN {
      /**
     * Java does not provide a function for log(base10). This is how you
     * do it. (see Que, Using Java 1.1, pg. 506).
     */
    public static double log10 (double val) {

	final double logOf10 = Math.log(10.0);

	if (val > 0) {
	    return Math.log(val) / logOf10;
	} else {
	    return 0.0;		// should throw exception? or NaN?
	}
    }
}