package org.trinet.jiggle;

/*
 * Based on /opt/swing-1.0.2/examples/Metalworks/src/MetalworksPrefs.java
 */

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.text.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.*;

import org.trinet.util.graphics.ColumnLayout;

/**
  * This dialog allows user to choose Jiggle preferences
  */
public class PreferencesDialog extends CenteredDialog {

    JiggleProperties oldProps;	    // old set of properties
    JiggleProperties newProps;	    // new properties as changed by this dialog

    JPanel container = new JPanel( new BorderLayout());	    // the main dialog panel

    JTextField driverField;
    JTextField dbaseHostField;
    JTextField dbaseDomainField;
    JTextField dbasePortField;
    JTextField dbaseNameField;
    JTextField userNameField;
    JTextField jasiTypeField;
    JPasswordField passwordField;   // don't echo password text

    JTextField locEngType;
    JTextField locEngUrl;
    JTextField locEngPort;

    JTextField netCodeField;
    JTextField cacheAboveField;
    JTextField cacheBelowField;
    JTextField pickStripValueField;
    JTextField clockQualityValueField;

    // make the tabbed panels
    JTabbedPane tabs = new JTabbedPane();

    FlowLayout flowLayout1 = new FlowLayout();

/** Tab numbers */
    public final static int TAB_DATACONNECTION = 0;
    public final static int TAB_LOCSERVER = 1;
    public final static int TAB_WAVEDATASOURCE = 2;
    public final static int TAB_CHANWINMODEL = 3;
    public final static int TAB_MISC = 4;

    int topTab = 0;

    /** Constructor */
    public PreferencesDialog(JiggleProperties properties) {
        this(properties, 0);
    }
    /** Constructor */
    public PreferencesDialog(JiggleProperties properties, int tabNumber) {

       super(null, "Preferences", true);

        oldProps = properties;	          // this class will NOT affect the original copy
//	newProps = (JiggleProperties) oldProps.clone();
	newProps = (JiggleProperties) oldProps.deepClone();

	topTab = tabNumber;

        try  {
             jbInit();
        }
        catch(Exception ex) {
             ex.printStackTrace();
        }
     }

/** Build the GUI */
     private void jbInit() throws Exception {

 //	container = new JPanel();	    // the main dialog panel
 //	container.setLayout( new BorderLayout() );

 // remove contents so we can call this again without repeating components
        container.removeAll();
        tabs.removeAll();

	JPanel dbase = buildDbasePanel();
	tabs.addTab( "Data Connection", null, dbase );

//	JPanel locEng = buildLocServerPanel();
	JPanel locEng = new DPLocationEngine(newProps);
	tabs.addTab( "Location Server", null, locEng );

	JPanel wfSource = (JPanel) new DPwaveSource(newProps);
	tabs.addTab( "Wavedata Source", null, wfSource );

	JPanel ctwmPanel = (JPanel) new DPChannelTimeWindowModel(newProps);
	tabs.addTab( "Chan/Window Models", null, ctwmPanel );

	JPanel misc = buildMiscPanel();
	tabs.addTab( "Other", null, misc );

	/*
	JPanel display = buildDisplayPanel();
	tabs.addTab( "Test 1", null, display );

	JPanel conn = buildConnectingPanel();
	tabs.addTab( "Text 2", null, conn );
	*/
    // define the buttons: [OK] [Reset]  [Cancel]

	JPanel buttonPanel = new JPanel();

	JButton ok = new JButton("OK");
	ok.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   OKPressed();
			       }});
        ok.setToolTipText("Use changes");
	buttonPanel.add( ok );
/*
	JButton apply = new JButton("Apply");
	apply.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   applyPressed();
			       }});
	buttonPanel.add( apply );
*/
	JButton reset = new JButton("Reset");
	reset.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   resetPressed();
			       }});
        reset.setToolTipText("Reset properties in ALL tabs to original values.");
	buttonPanel.add( reset );

	buttonPanel.setLayout ( flowLayout1 );
	JButton cancel = new JButton("Cancel");
	cancel.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   cancelPressed();
			       }});
        cancel.setToolTipText("Cancel changes");
	buttonPanel.add( cancel );

	getRootPane().setDefaultButton(ok); // default button

	container.add(tabs, BorderLayout.CENTER);
	container.add(buttonPanel, BorderLayout.SOUTH);

	getContentPane().add(container);

	pack();
	centerDialog();

	// bring the chosen tab to the front
	tabs.setSelectedIndex(topTab);

	show();

//	UIManager.addPropertyChangeListener(new UISwitchListener(container));
    }

    /** Create the panel. */
    private JPanel buildDisplayPanel() {

	JPanel displayPanel = new JPanel();
	displayPanel.setLayout( new GridLayout(1, 0) );

	JPanel panel1 = new JPanel();	// a subpanel w/ radio buttons

	displayPanel.setLayout(new ColumnLayout());
	displayPanel.setBorder( new TitledBorder("Radio buttons") );

	ButtonGroup group1	= new ButtonGroup();
	JRadioButton rb1	= new JRadioButton("Option #1");
	JRadioButton rb2	= new JRadioButton("Option #2");
	JRadioButton rb3	= new JRadioButton("Option #3");

	group1.add(rb1);	    // add buttons to group (only one in group can be pushed)
	group1.add(rb2);
	group1.add(rb3);

	panel1.add(rb1);	    // add buttons to panel
	panel1.add(rb2);
	panel1.add(rb3);

	rb1.setSelected(true);	    // set default
	displayPanel.add(panel1);


	JPanel panel2 = new JPanel();
	panel2.setLayout(new ColumnLayout());
	panel2.setBorder( new TitledBorder("More crap") );

	ButtonGroup group2 = new ButtonGroup();
	JRadioButton rb21 = new JRadioButton("Nothing");
	JRadioButton rb22 = new JRadioButton("Less then nothing");
	JRadioButton rb23 = new JRadioButton("Really in the hole");

	group2.add(rb21);
	group2.add(rb22);
	group2.add(rb23);

	panel2.add(rb21);
	panel2.add(rb22);
	panel2.add(rb23);

	rb23.setSelected(true);
	displayPanel.add(panel2);

	return displayPanel;
    }
    //
    private JPanel buildConnectingPanel() {
	JPanel connectPanel = new JPanel();
	connectPanel.setLayout( new ColumnLayout() );

	JPanel protoPanel = new JPanel();
	JLabel protoLabel = new JLabel ("Protocol");
	JComboBox protocol = new JComboBox();
	protocol.addItem("Test 1");
	protocol.addItem("Test 2");
	protocol.addItem("Other...");
	protoPanel.add(protoLabel);
	protoPanel.add(protocol);

	JPanel attachmentPanel = new JPanel();
	JLabel attachmentLabel = new JLabel ("Some other stuff");
	JComboBox attach = new JComboBox();
	attach.addItem("Subitem 1");
	attach.addItem("Subitem 2");
	attach.addItem("Subitem 3");
	attach.addItem("Subitem 4");
	attachmentPanel.add(attachmentLabel);
	attachmentPanel.add(attach);

	JCheckBox autoConn = new JCheckBox("Check Box 1");
	JCheckBox compress = new JCheckBox("Check Box 2");
	autoConn.setSelected( true );

	connectPanel.add(protoPanel);
	connectPanel.add(attachmentPanel);
	connectPanel.add(autoConn);
	connectPanel.add(compress);
	return connectPanel;
    }

    //
    private JPanel buildMiscPanel() {

	DecimalFormat df1 = new DecimalFormat ( "###0" );
	DecimalFormat df2 = new DecimalFormat ( "#0.00" );

	MiscDocListener miscDocListener =  new MiscDocListener(this);

	String netCode	= oldProps.getProperty("localNetCode");
	int cacheAbove	= oldProps.getInt("cacheAbove");
	int cacheBelow	= oldProps.getInt("cacheBelow");
	float pickStripValue	= oldProps.getFloat("pickStripValue");
	float clockQualityValue	= oldProps.getFloat("clockQualityThreshold");

	JPanel miscPanel = new JPanel();
	miscPanel.setLayout( new ColumnLayout() );

// network code
        netCodeField = new JTextField(netCode);
	// this doesn't to shit!
	//	Font font = netCodeField.getFont();
	//	FontMetrics fm =netCodeField.getFontMetrics(font) ;
	//	netCodeField.setSize(fm.stringWidth("MMM"), fm.getHeight());

	JPanel netCodePanel = new JPanel();
        netCodeField.getDocument().addDocumentListener(miscDocListener);
	netCodePanel.add(new JLabel ("Seismic Network Code: "));
	netCodePanel.add(netCodeField);
	netCodePanel.setToolTipText("Set default FDSN-style network code.");

// waveform loader cache values
	JPanel cachePanel = new JPanel(new ColumnLayout()); // will have 2 rows
	cachePanel.add(new JLabel ("Waveform cache size"), SwingConstants.CENTER);
	JPanel cacheValPanel = new JPanel();   // flow layout
        cacheAboveField = new JTextField(df1.format(cacheAbove));
          cacheAboveField.getDocument().addDocumentListener(miscDocListener);
	  cacheValPanel.add(new JLabel ("Above: "));
	  cacheValPanel.add(cacheAboveField);
        cacheBelowField = new JTextField(df1.format(cacheBelow));
	  cacheValPanel.add(new JLabel (" Below: "));
	  cacheValPanel.add(cacheBelowField);
	  cachePanel.add(cacheValPanel);
        cachePanel.setBorder(BorderFactory.createLineBorder(Color.black));
	cachePanel.setToolTipText("Timeseries dynamic loader cache");

// pick strip value
        pickStripValueField = new JTextField(df2.format(pickStripValue));
	JPanel pickStripValuePanel = new JPanel();;
	pickStripValueField.getDocument().addDocumentListener(miscDocListener);
	pickStripValuePanel.add(new JLabel ("Strip Picks Value: "));
	pickStripValuePanel.add(pickStripValueField);
	pickStripValuePanel.setToolTipText("Set default strip-picks value.");

// clock quality value
	clockQualityValueField = new JTextField(df2.format(clockQualityValue));
	JPanel clockQualityValuePanel = new JPanel();
	clockQualityValuePanel.setToolTipText("Waveform panel frame will be red if clock quality is worse than this.");
	clockQualityValueField.getDocument().addDocumentListener(miscDocListener);
	clockQualityValuePanel.add(new JLabel ("Clock quality threshold: "));
	clockQualityValuePanel.add(clockQualityValueField);

	miscPanel.add(netCodePanel);
	miscPanel.add(cachePanel);
	miscPanel.add(pickStripValuePanel);
	miscPanel.add(clockQualityValuePanel);

	// check boxes

	return miscPanel;
    }

    /**
     * Creates the dbase panel which will contain all the fields for
     * the connection information.
     */
    private JPanel buildDbasePanel() {

	//	String url	= oldProps.getProperty("dbaseURL");
	String dbaseHost   = oldProps.getProperty("dbaseHost");
	String dbaseDomain = oldProps.getProperty("dbaseDomain");
	String dbaseName   = oldProps.getProperty("dbaseName");
	String dbasePort   = oldProps.getProperty("dbasePort");

	String driver	= oldProps.getProperty("dbaseDriver");
	String user	= oldProps.getProperty("dbaseUser");
	String passwd	= oldProps.getProperty("dbasePasswd");

	String jasiType = oldProps.getProperty("jasiObjectType");

	// A document listener will change newProps values as fields are edited
	DbDocListener dbDocListener =  new DbDocListener(this);

        // Create the labels and text fields.
        JLabel     hostLabel = new JLabel("Database host: ", JLabel.RIGHT);
        dbaseHostField = new JTextField(dbaseHost);
	dbaseHostField.getDocument().addDocumentListener(dbDocListener);

        JLabel     domainLabel = new JLabel("Database domain: ", JLabel.RIGHT);
        dbaseDomainField = new JTextField(dbaseDomain);
	dbaseDomainField.getDocument().addDocumentListener(dbDocListener);

        JLabel     nameLabel = new JLabel("Database name: ", JLabel.RIGHT);
        dbaseNameField = new JTextField(dbaseName);
	dbaseNameField.getDocument().addDocumentListener(dbDocListener);

        JLabel     portLabel = new JLabel("Database Port#: ", JLabel.RIGHT);
        dbasePortField = new JTextField(dbasePort);
	dbasePortField.getDocument().addDocumentListener(dbDocListener);

        JLabel     userNameLabel = new JLabel("Username: ", JLabel.RIGHT);
        userNameField = new JTextField(user);
	userNameField.getDocument().addDocumentListener(dbDocListener);

        JLabel         passwordLabel = new JLabel("Password: ", JLabel.RIGHT);
        passwordField = new JPasswordField(passwd);   // don't echo password text
	passwordField.getDocument().addDocumentListener(dbDocListener);

        JLabel     driverLabel = new JLabel("Driver: ", JLabel.RIGHT);
        driverField = new JTextField(driver);
	driverField.getDocument().addDocumentListener(dbDocListener);

        JLabel     jasiTypeLabel = new JLabel("Jasi Data Type: ", JLabel.RIGHT);
        jasiTypeField = new JTextField(jasiType);
	jasiTypeField.getDocument().addDocumentListener(dbDocListener);

        JPanel connectionPanel = new JPanel(false);
        connectionPanel.setLayout(new BoxLayout(connectionPanel,
                                                BoxLayout.X_AXIS));

	connectionPanel.setBorder( new TitledBorder("Dbase connection info") );

        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new GridLayout(0, 1));
        namePanel.add(hostLabel);
        namePanel.add(domainLabel);
        namePanel.add(nameLabel);
        namePanel.add(portLabel);
        namePanel.add(userNameLabel);
        namePanel.add(passwordLabel);
        namePanel.add(driverLabel);
        namePanel.add(jasiTypeLabel);

        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new GridLayout(0, 1));
        fieldPanel.add(dbaseHostField);
        fieldPanel.add(dbaseDomainField);
        fieldPanel.add(dbaseNameField);
        fieldPanel.add(dbasePortField);
        fieldPanel.add(userNameField);
        fieldPanel.add(passwordField);
        fieldPanel.add(driverField);
        fieldPanel.add(jasiTypeField);

        connectionPanel.add(namePanel);
        connectionPanel.add(fieldPanel);

	return connectionPanel;
    }

    /**
     * Creates the dbase panel which will contain all the fields for
     * the connection information.
     */
    private JPanel buildLocServerPanel() {

	String type	= oldProps.getProperty("locationEngineType");
	String url	= oldProps.getProperty("locationEngineAddress");
	String port	= oldProps.getProperty("locationEnginePort");

	// A document listener will change newProps values as fields are edited
	//	dbDocListener dbDocListener =  new dbDocListener(this);
	LocServerDocListener locServerDocListener = new LocServerDocListener(this);

        // Create the labels and text fields.
        JLabel     label1 = new JLabel("Type: ", JLabel.RIGHT);
        locEngType = new JTextField(type);
	locEngType.getDocument().addDocumentListener(locServerDocListener);

        JLabel         label2 = new JLabel("IP-address: ", JLabel.RIGHT);
        locEngUrl = new JTextField(url);   // don't echo password text
	locEngUrl.getDocument().addDocumentListener(locServerDocListener);

        JLabel     label3 = new JLabel("Port #: ", JLabel.RIGHT);
        locEngPort = new JTextField(port);
	locEngPort.getDocument().addDocumentListener(locServerDocListener);

        JPanel connectionPanel = new JPanel(false);
        connectionPanel.setLayout(new BoxLayout(connectionPanel,
                                                BoxLayout.X_AXIS));

	connectionPanel.setBorder( new TitledBorder("Location Engine connection info") );

        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new GridLayout(0, 1));
        namePanel.add(label1);
        namePanel.add(label2);
        namePanel.add(label3);

        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new GridLayout(0, 1));
        fieldPanel.add(locEngType);
        fieldPanel.add(locEngUrl);
        fieldPanel.add(locEngPort);

        connectionPanel.add(namePanel);
        connectionPanel.add(fieldPanel);

	return connectionPanel;
    }

     /** Return the JiggleProperties */
     public JiggleProperties getJiggleProperties () {
            return newProps;
     }

// //////////////////////////////////////////////////////////////////
/**
 *  Action to take when [Cancel] is pressed
 *  Close dialog, make no changes
 */
    public void cancelPressed() {
        returnValue = JOptionPane.CANCEL_OPTION;
        this.setVisible(false);
    }

/**
 *  Action to take when [OK] is pressed
 *  Close dialog, make changes
 */
    public void OKPressed() {

        returnValue = JOptionPane.OK_OPTION;
        this.setVisible(false);	    // dismiss dialog
    }
/**
 *  Action to take when [Apply] is pressed
 *  Make changes but don't close dialog.
 */
/*
    public void applyPressed() {

	// Have to check now before old ones are destroyed
	boolean dbChanged = dbaseChanged();

    }
*/
/**
 *  Action to take when [Reset] is pressed
 *  Reset all preferences to original values that are in the files.
 */
    public void resetPressed() {

        // return to the same tab after reset
       int index = tabs.getSelectedIndex();

	  newProps = (JiggleProperties) oldProps.clone(); // a copy of the old list

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

       tabs.setSelectedIndex(index);

    }

    /** Returns true if any of the DataSource properties were changed. */
    public boolean dataSourceChanged () {
	return !oldProps.dataSourceEquals(newProps);
	/*
	if (
//	    oldProps.getProperty("dbaseURL") != newProps.getProperty("dbaseURL") ||
//	    oldProps.getProperty("dbaseDriver") != newProps.getProperty("dbaseDriver") ||
//	    oldProps.getProperty("dbaseUser") != newProps.getProperty("dbaseUser") ||
//	    oldProps.getProperty("dbasePasswd") != newProps.getProperty("dbasePasswd")
	    !oldProps.getProperty("dbaseHost"  ).equals(newProps.getProperty("dbaseHost"))||
	    !oldProps.getProperty("dbaseDomain").equals(newProps.getProperty("dbaseDomain"))||
	    !oldProps.getProperty("dbaseName"  ).equals(newProps.getProperty("dbaseName"))||
	    !oldProps.getProperty("dbasePort"  ).equals(newProps.getProperty("dbasePort"))||
 	    !oldProps.getProperty("dbaseDriver").equals(newProps.getProperty("dbaseDriver")) ||
	    !oldProps.getProperty("dbaseUser"  ).equals(newProps.getProperty("dbaseUser")) ||
	    !oldProps.getProperty("dbasePasswd").equals(newProps.getProperty("dbasePasswd"))
	    ) return true;
	return false;
	*/
   }
    /** Returns true if any of the wavesource properties were changed. */
    public boolean waveSourceChanged () {
        return !oldProps.waveSourceEquals(newProps);
	/*
	if (
//	    oldProps.getProperty("waveformReadMode") != newProps.getProperty("waveformReadMode") ||
// 	    oldProps.getProperty("waveServerGroupList") != newProps.getProperty("waveServerGroupList") ||
//	    oldProps.getProperty("currentWaveServerGroup") != newProps.getProperty("currentWaveServerGroup")
	    !oldProps.getProperty("waveformReadMode").equals(newProps.getProperty("waveformReadMode")) ||
 	    !oldProps.getProperty("waveServerGroupList").equals(newProps.getProperty("waveServerGroupList")) ||
	    !oldProps.getProperty("currentWaveServerGroup").equals(newProps.getProperty("currentWaveServerGroup"))
	    ) return true;

	return false;
*/
   }
    /** Returns true if the ChannelTimeWindowModel changed. */
    public boolean channelTimeWindowModelChanged () {
      return !oldProps.channelTimeWindowModelEquals(newProps);

	//    String oldm = oldProps.getCurrentChannelTimeWindowModelClassName();
	//    String newm = newProps.getCurrentChannelTimeWindowModelClassName();
      	//    return !oldm.equals(newm);
    }
/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String s[]) {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.pack();
        frame.setVisible(true);


	JiggleProperties props = new JiggleProperties("properties");

	System.out.println ("----------- Current Properties -------------");
	props.dumpProperties();

	PreferencesDialog prefDialog = new PreferencesDialog(props);

// Preferences Dialog

	if (prefDialog.getButtonStatus() == JOptionPane.OK_OPTION) {

	    // get the changed properties
            JiggleProperties newprops = prefDialog.getJiggleProperties();
            PreferencesDialog.savePropertiesDialog(newprops);

	    System.out.println ("--------- New Properties -------------");

	    newprops.dumpProperties();
	} else {
	     System.out.println ("Properties not changed. ");
	}

	System.exit(0);

    }
/**
 * Pop dialog asking if preferences should be saved.
 */
    public static void savePropertiesDialog(JiggleProperties props)
    {
    //pop confirming  yes/no dialog:
           int n = JOptionPane.showConfirmDialog(
                   null, "Save current properties to startup file?",
                   "Save Properties?",
                   JOptionPane.YES_NO_OPTION);

	    if (n == JOptionPane.YES_OPTION) {

		props.saveProperties();
	    }
    }

} // end of PrefsDialog class

// /////////////////////////////////////////////////////////////////////////////
// INNER CLASSES
// /////////////////////////////////////////////////////////////////////////////
    /**
     * This is better then an actionListener because it updates
     * the values as they are edited and does not require that the user
     * hit a <CR> to trigger the listener.
     */
    class DbDocListener implements DocumentListener {

	PreferencesDialog dia;

	// Passes reference to the caller so we can see and change some stuff
	public DbDocListener(PreferencesDialog pd){
	    dia = pd;  // need reference to see other variables
	}
         public void insertUpdate(DocumentEvent e) {
             setValues(e);
         }
         public void removeUpdate(DocumentEvent e) {
             setValues(e);
         }
         public void changedUpdate(DocumentEvent e) {
             // we won't ever get this with a PlainDocument
         }

     private void setValues(DocumentEvent e) {

		 // don't know what is being editied so just read 'em all

		 // GDataSource connnection
		 dia.newProps.setProperty("dbaseHost", dia.dbaseHostField.getText().trim() );

		 dia.newProps.setProperty("dbaseDomain", dia.dbaseDomainField.getText().trim() );

		 dia.newProps.setProperty("dbaseName", dia.dbaseNameField.getText().trim() );

		 dia.newProps.setProperty("dbasePort", dia.dbasePortField.getText().trim() );

		 dia.newProps.setProperty("dbaseDriver", dia.driverField.getText().trim() );

		 dia.newProps.setProperty("dbaseUser", dia.userNameField.getText().trim() );
		 String pwd = new String(dia.passwordField.getPassword());
		 dia.newProps.setProperty("dbasePasswd", pwd.trim() );

		 dia.newProps.setProperty("jasiObjectType", dia.jasiTypeField.getText().trim() );

	     }
         }

    /**
     * This is better then an actionListener because it updates
     * the values as they are edited and does not require that the user
     * hit a <CR> to trigger the listener.
     */
    class LocServerDocListener implements DocumentListener {

	PreferencesDialog dia;

	// Passes reference to the caller so we can see and change some stuff
	public LocServerDocListener(PreferencesDialog pd)
	{
	    dia = pd;  // need reference to see other variables
	}
             public void insertUpdate(DocumentEvent e) {
                 setValues(e);
             }
             public void removeUpdate(DocumentEvent e) {
                 setValues(e);
             }
             public void changedUpdate(DocumentEvent e) {
                 // we won't ever get this with a PlainDocument
             }

     private void setValues(DocumentEvent e) {

		 // don't know what is being editied so just read 'em all

		 // Location engine
		 dia.newProps.setProperty("locationEngineType",
				      dia.locEngType.getText().trim() );
		 dia.newProps.setProperty("locationEngineAddress",
				      dia.locEngUrl.getText().trim() );
		 dia.newProps.setProperty("locationEnginePort",
				      dia.locEngPort.getText().trim() );

     }
    }

    class MiscDocListener implements DocumentListener {

	PreferencesDialog dia;

	// Passes reference to the caller so we can see and change some stuff
	public MiscDocListener(PreferencesDialog pd)
	{
	    dia = pd;  // need reference to see other variables
	}
             public void insertUpdate(DocumentEvent e) {
                 setValues(e);
             }
             public void removeUpdate(DocumentEvent e) {
                 setValues(e);
             }
             public void changedUpdate(DocumentEvent e) {
                 // we won't ever get this with a PlainDocument
             }

     private void setValues(DocumentEvent e) {

	 // no sanity checking on numbers !
		 dia.newProps.setProperty("localNetCode",
					  dia.netCodeField.getText().trim() );
		 dia.newProps.setProperty("cacheAbove",
					  dia.cacheAboveField.getText().trim() );
		 dia.newProps.setProperty("cacheBelow",
					  dia.cacheBelowField.getText().trim() );
		 dia.newProps.setProperty("pickStripValue",
					  dia.pickStripValueField.getText().trim() );
		 dia.newProps.setProperty("clockQualityThreshold",
					  dia.clockQualityValueField.getText().trim() );

     }
    }