package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*; 
import javax.swing.border.*;

import org.trinet.jdbc.*;
import org.trinet.jasi.*;

/**
 * This is the Pop-up dialog that appears after a new phase pick is made or when
 * you want to edit an existing phase pick.  */

public class PhaseDialog extends JDialog
/*
Tried making this a JFrame rather then a JDialog because a JDialog needs a
reference to the main frame an this is nested to far down to get one. HOWEVER,
if you do this as a frame it doesn't block! So the code moves on without the
input this dialog is intended to provide.  */

//public class PhaseDialog extends JFrame
{

  WFPanel wfp;
  Phase ph;
    //  Phase phCopy;
  MasterView mv;

    /** copy of phase description we'll work with until committed */
    //  PhaseDescription desc;

/** support old style weight */
  int wt;	

  String phaseChoice[] = {
    "P",
    "S",
    "Pn",
    "Sn"};
  JComboBox phaseCombo;

  SolutionListComboBox solListCombo;    // to select association

  RadioListener radioListener = new RadioListener(); // all buttons will register same instance

/**
 * Need Phase, MasterView and WFView to completely handle all the bookkeeping for 
 * changing, adding, deleting phases
 */
public PhaseDialog(Frame frame, Component comp, 
		   WFPanel wfp, MasterView mv, Phase ph) 
{
    //    Frame frame  = (Frame) wfp.getTopLevelAncestor();

    super (frame, "Phase Description", true);

    // Set our location (0,0) relative to the given component
    //    setLocationRelativeTo(comp);

    this.wfp = wfp;
    this.ph  = ph;
    this.mv  = mv;

    //    phCopy = Phase.create(ph);

    //    desc = new PhaseDescription(ph.description);	// copy we'll work on

    //    System.out.println ("From PhaseDialog...");

// Build the dialog box
    
    Box box = new Box(BoxLayout.Y_AXIS);

    phaseCombo	= makeComboBox(phaseChoice);
    phaseCombo.setEditable(true);	// make phaseCombo editable, default is NOT editable

    JPanel iePanel = createIePanel();
    JPanel fmPanel = createFmPanel();
    JPanel wtPanel = createWtPanel();

    JPanel labelPanel = new JPanel();
    labelPanel.setLayout(new GridLayout(0, 1));
    labelPanel.add(new JLabel("Phase: ", JLabel.RIGHT) );
    labelPanel.add(new JLabel("Onset: ", JLabel.RIGHT) );
    labelPanel.add(new JLabel("1st Mo: ", JLabel.RIGHT) );
    labelPanel.add(new JLabel("Weight: ", JLabel.RIGHT) );

    JPanel chooserPanel = new JPanel();
    chooserPanel.setLayout(new GridLayout(0, 1));

    chooserPanel.add(phaseCombo);
    chooserPanel.add(iePanel);
    chooserPanel.add(fmPanel);
    chooserPanel.add(wtPanel);

    JPanel descPanel = new JPanel();
    descPanel.setLayout(new BoxLayout(descPanel, BoxLayout.X_AXIS));
    descPanel.setBorder( new TitledBorder("Phase Description") );
    descPanel.add(labelPanel);
    descPanel.add(chooserPanel);

    solListCombo = new SolutionListComboBox (mv.solList);

    JPanel assocPanel = new JPanel();
    assocPanel.setBorder( new TitledBorder("Association") );
    assocPanel.add(solListCombo);

// Set selected Solution in the comboBox to the one in the Masterview's model
//    solListCombo.setSelected(mv.solList.getSelected());
    solListCombo.addActionListener(new SolutionComboHandler() );

// set default values to match current phase
    phaseCombo.setSelectedItem(ph.description.iphase);

// The express button Panel

    JPanel expressPanel = createExpressPanel();

// define the buttons: [OK] [Delete]       [Cancel]?

    JPanel buttonPanel = new JPanel();	

//	JButton ok = new JButton("OK");
    JButton okButton = new JButton("OK");
    okButton.addActionListener(new ActionListener() {
			   public void actionPerformed(ActionEvent e) {
			       OKPressed();
			   }});
    buttonPanel.add( okButton );


    JButton cancelButton = new JButton("Cancel");
    cancelButton.addActionListener(new ActionListener() {
			   public void actionPerformed(ActionEvent e) {
			       CancelPressed();
			   }});
    buttonPanel.add( cancelButton );

    JButton deleteButton = new JButton("Delete");
    deleteButton.addActionListener(new ActionListener() {
			   public void actionPerformed(ActionEvent e) {
			       DeletePressed();
			   }});
    buttonPanel.add( deleteButton );

// the main panel
    JPanel mainPanel = new JPanel();	    // the main dialog panel
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

    mainPanel.add(descPanel);
    mainPanel.add(assocPanel);
    mainPanel.add(expressPanel);
    mainPanel.add(buttonPanel);

    getContentPane().add(mainPanel);

    pack();
    show();
}

/**
 * create I/E radio button group
 */
    JPanel createIePanel()
    {
      JRadioButton button1 = makeButton("i", 'i');
      JRadioButton button2 = makeButton("e", 'e');
      JRadioButton button3 = makeButton("w", 'w');

      button1.setSelected(true);				// 'i' default
      if (ph.description.ei == "e") button2.setSelected(true);
      if (ph.description.ei == "w") button3.setSelected(true);

    // Group the radio buttons.
      ButtonGroup buttonGroup = new ButtonGroup();
      buttonGroup.add(button1);
      buttonGroup.add(button2);
      buttonGroup.add(button3);

      JPanel panel = new JPanel();
      panel.add(button1);
      panel.add(button2);
      panel.add(button3);

      return panel;

    }

/**
 * create First Motion radio button group
 */
    JPanel createFmPanel()
    {
      JRadioButton button1 = makeButton("c", 'c');
      JRadioButton button2 = makeButton("d", 'd');
      JRadioButton button3 = makeButton("u", 'u');
      JRadioButton button4 = makeButton("r", 'r');
      JRadioButton button5 = makeButton(".", '.');

    // Group the radio buttons.
      ButtonGroup buttonGroup = new ButtonGroup();
      buttonGroup.add(button1);
      buttonGroup.add(button2);
      buttonGroup.add(button3);
      buttonGroup.add(button4);
      buttonGroup.add(button5);

      JPanel panel = new JPanel();
      panel.add(button1);
      panel.add(button2);
      panel.add(button3);
      panel.add(button4);
      panel.add(button5);

      button1.setSelected(true);			    // 'c' default
      if (ph.description.fm.equals("d.")) button2.setSelected(true);
      if (ph.description.fm.equals("u.")) button3.setSelected(true);
      if (ph.description.fm.equals("r.")) button4.setSelected(true);
      if (ph.description.fm.equals("..")) button5.setSelected(true);

      return panel;

    }

/**
 * create (old style) Weight radio button group
 */
    JPanel createWtPanel()
    {
      JRadioButton button1 = makeButton("0", '0');
      JRadioButton button2 = makeButton("1", '1');
      JRadioButton button3 = makeButton("2", '2');
      JRadioButton button4 = makeButton("3", '3');
      JRadioButton button5 = makeButton("4", '4');

    // Group the radio buttons.
      ButtonGroup buttonGroup = new ButtonGroup();
      buttonGroup.add(button1);
      buttonGroup.add(button2);
      buttonGroup.add(button3);
      buttonGroup.add(button4);
      buttonGroup.add(button5);

      JPanel panel = new JPanel();
      panel.add(button1);
      panel.add(button2);
      panel.add(button3);
      panel.add(button4);
      panel.add(button5);

// convert 0->1 quality to 0,1,2,3,4 weight
//TODO: check this
      int wt = ph.description.getWeight();
      button1.setSelected(true);		    // default
      if (wt == 1) button2.setSelected(true);
      if (wt == 2) button3.setSelected(true);
      if (wt == 3) button4.setSelected(true);
      if (wt == 4) button5.setSelected(true);

      return panel;
    }

/**
 * Make the subPanel that has one-touch express buttons like 'IP0' ...
 */
    JPanel createExpressPanel()
    {
	JPanel pPanel = new JPanel();	
	JPanel sPanel = new JPanel();

	pPanel.setLayout(new BoxLayout(pPanel, BoxLayout.X_AXIS));
	sPanel.setLayout(new BoxLayout(sPanel, BoxLayout.X_AXIS));

	addExpressButton (new JButton("iP0"), pPanel);
	addExpressButton (new JButton("iP1"), pPanel);
	addExpressButton (new JButton("eP2"), pPanel);
	addExpressButton (new JButton("eP3"), pPanel);
	addExpressButton (new JButton("eP4"), pPanel);

	addExpressButton (new JButton("iS0"), sPanel);
	addExpressButton (new JButton("iS1"), sPanel);
	addExpressButton (new JButton("eS2"), sPanel);
	addExpressButton (new JButton("eS3"), sPanel);
	addExpressButton (new JButton("eS4"), sPanel);

	JPanel expPanel = new JPanel();
	expPanel.setLayout(new BoxLayout(expPanel, BoxLayout.Y_AXIS));

	expPanel.setBorder( new TitledBorder("Express Buttons") );

	expPanel.add(pPanel);
	expPanel.add(sPanel);

	return expPanel;
    }

/*-----------------------------------------------------------------
 *  method to stream line adding of buttons
 */
     void addExpressButton (JButton btn, JPanel panel)
    {
      btn.addActionListener (new ExpressButtonHandler() );
      panel.add(btn);
    }


// Handle express buttons
class ExpressButtonHandler implements ActionListener
    {    
	public void actionPerformed (ActionEvent evt) 
	{
          String str = evt.getActionCommand();

	  // parse the short Phase descriptor string from the button (e.g. "eP2")
	  String ei     = str.substring(0,1);
	  String iphase = str.substring(1,2);	
	  String wt     = str.substring(2,3); 
	  int weight    = 4;
	  if (wt != null) {
	      weight    = Integer.valueOf( wt ).intValue();
       }
	  String fm	= ph.description.fm;	//???

	  //	  desc.set(qual, iphase, qstr, fm);
	  ph.description.set(iphase, ei, fm, weight);

	// set new association to currently selected solution
       Solution sol =  mv.getSelectedSolution();
	  ph.associate( sol );

	  // add the phase to the WFView
	  sol.phaseList.addOrReplacePhase(ph);


//TODO: calculate and set dmin, residual, etc. OR leave null until location is recalc'ed.

          setVisible(false);	    // dismiss dialog

	}
    }


/**
 * Generic RadioButton maker. Just simplifies the code a bit
 */
    JRadioButton makeButton (String cmd, char mnem)
    {
      JRadioButton rb = new JRadioButton(cmd);
      rb.setMnemonic(mnem);
      rb.setActionCommand(cmd);
      rb.addActionListener(radioListener);
      return rb;
    }
/**
 * Simplify creation of JComboBoxes
 */
public JComboBox makeComboBox(String[] choiceList)
{
    JComboBox cb = new JComboBox(); 

    for (int i = 0; i< choiceList.length; i++)
    {
      cb.addItem(choiceList[i]);
    }

    cb.setEditable(true);		    // allow freeform user input
    cb.setSelectedItem(phaseChoice[0]);	    // default selection
    cb.setMaximumRowCount(4);		    // items displayed in scrolling window

    cb.setEditable(false);

    Dimension size = cb.getSize();

    cb.setSize(20, size.height);

    return cb;
}

// ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS ACTIONS 
/**
 *  Action to take when [DELETE] is pressed
 *  Close dialog, delete the selected phase
 */
    public void DeletePressed() {

	    // Delete it in Solution's list so listeners know
         mv.getSelectedSolution().phaseList.delete(ph);

        this.setVisible(false);
    }

/**
 *  Action to take when [CANCEL] is pressed. Final disposition is made by the
 *  caller (MultiWFPanel) A new pick will never be added to any phaseList and so
 *  will be truely deleted. An old pick will revert back to its previous values
 *  and time.  */
    public void CancelPressed() {

	// TODO
        this.setVisible(false);
    }

/**
 *  Action to take when [OK] is pressed
 *  Close dialog, make changes
 */
    public void OKPressed() {

	// time is already set by the caller
 
	ph.description.iphase = (String) phaseCombo.getSelectedItem();

	// set new association to selected solution
	ph.associate( mv.solList.getSelected() );	

     // Add it in Solution's list so listeners know
     mv.getSelectedSolution().phaseList.addOrReplacePhase(ph);

	// fm, qual & quality are changed dynamically by the radio buttons

//TODO: calculate and set dmin, residual, etc. OR leave null until location is recalc'ed.

      this.setVisible(false);	    // dismiss dialog
    }

/**
 * All buttons will register one instance of this listener. The ActionCommand,
 * 'cmdStr', of the button is used to tell what to do.  */

      class RadioListener implements ActionListener  {

	  public void actionPerformed(ActionEvent e) {	// source is a radio button
   
		if (e.getActionCommand().equals("i"))  ph.description.ei = "i";
		if (e.getActionCommand().equals("e"))  ph.description.ei = "e"; 
		if (e.getActionCommand().equals("w"))  ph.description.ei = "w"; 

		if (e.getActionCommand().equals("c"))  ph.description.fm = "c."; 
		if (e.getActionCommand().equals("d"))  ph.description.fm = "d."; 
		if (e.getActionCommand().equals("u"))  ph.description.fm = "u."; 
		if (e.getActionCommand().equals("r"))  ph.description.fm = "r."; 
		if (e.getActionCommand().equals("."))  ph.description.fm = ".."; 

		if (e.getActionCommand().equals("0"))  wt = 0; 
		if (e.getActionCommand().equals("1"))  wt = 1; 
		if (e.getActionCommand().equals("2"))  wt = 2; 
		if (e.getActionCommand().equals("3"))  wt = 3; 
		if (e.getActionCommand().equals("4"))  wt = 4; 

		ph.description.setQuality(PhaseDescription.toQuality(wt));  // convert to "quality"

	    }
	}


/** Handle changes to the selected Solution that are made in a SolutionCombobox.
 */
    class SolutionComboHandler implements ActionListener {
	// this is the action taken when the selectedOrigin is changed
	  public void actionPerformed(ActionEvent e) {
	      SolutionListComboBox jc = (SolutionListComboBox) e.getSource();

	      mv.solList.setSelected( jc.getSelectedSolution() );	
	  }
    }

} // end of class

