
//Title:        Jiggle
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import org.trinet.jasi.*;

/** Creates a centered, modal dialog box for entering a comment
text string. If the dialog is cancelled the resulting string is set null.
No limit is put on the size of the string but if it's longer then the text field
it will scroll.  */
/*
  This code was generated using JBuilders GUI design interface.
 */

public class CommentDialog extends CenteredDialog{

    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JTextField textField = new JTextField();

    static final String title = "Add/Edit Comment";
    static final boolean modal = true;
    String commentString = null;
     JButton deleteButton = new JButton();

    public CommentDialog(String initComment) {
	super((JFrame) null, title, modal);
	commentString = initComment;
	try  {
	    jbInit();
	    pack();
	    centerDialog();
	}
	catch(Exception ex) {
	    ex.printStackTrace();
    }
	setVisible(true);
    }

    public CommentDialog() {
	this("");
    }

    void jbInit() throws Exception {

	panel1.setLayout(borderLayout1);
	// [OK] button
	okButton.setText("OK");
	okButton.addActionListener(new java.awt.event.ActionListener() {

	    public void actionPerformed(ActionEvent e) {
            finished_actionPerformed(e);
	    }
	});
	//[CANCEL] button
	cancelButton.setText("CANCEL");
	cancelButton.addActionListener(new java.awt.event.ActionListener() {

	    public void actionPerformed(ActionEvent e) {
             returnValue = JOptionPane.CANCEL_OPTION;
	        commentString = null;
             setVisible(false);	    // dismiss dialog
	    }
	});
	// the textfield
	textField.setMinimumSize(new Dimension(100, 21));
	textField.setPreferredSize(new Dimension(300, 21));
	if (commentString != null) textField.setText(commentString);
	textField.addActionListener(new java.awt.event.ActionListener() {

	    public void actionPerformed(ActionEvent e) {
		finished_actionPerformed(e);
	    }
	});
	deleteButton.setText("DELETE");
	deleteButton.addActionListener(new java.awt.event.ActionListener() {

	    public void actionPerformed(ActionEvent e) {
             returnValue = JOptionPane.NO_OPTION;
	        commentString = null;
             setVisible(false);	    // dismiss dialog
	    }
	});

     getContentPane().add(panel1);
	panel1.add(jPanel1, BorderLayout.CENTER);
	jPanel1.add(textField, null);
	panel1.add(jPanel2, BorderLayout.SOUTH);
	jPanel2.add(okButton, null);
          jPanel2.add(deleteButton, null);
	jPanel2.add(cancelButton, null);
    }

    /** Return the comment string. */
    public String getString () {
	return commentString;
    }

    /** Either the OK button or carrage return in the text field */
    void finished_actionPerformed(ActionEvent e) {
        returnValue = JOptionPane.OK_OPTION;
	   commentString = textField.getText();
	   this.setVisible(false);	    // dismiss dialog
    }

    /** Cancel action */
/*    void cancelButton_actionPerformed(ActionEvent e) {
        returnValue = JOptionPane.CANCEL_OPTION;
	   commentString = null;
        this.setVisible(false);	    // dismiss dialog
    }
*/
  /**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String s[]) {

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection
	init.setWriteBackEnabled(true);

	// get one by evid
	int evid =  9629593;

	System.out.println ("Get one entry by evid = "+ evid);

     Solution sol = Solution.create().getById(evid);


        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.pack();
        frame.setVisible(true);

     String comm = "";
     if (sol.hasComment()) comm = sol.getComment();

     System.out.println (sol.toNeatString() + "\n"+
     "Comment: "+comm);

     CommentDialog dialog = new CommentDialog(comm);

     if (dialog.getButtonStatus() == JOptionPane.OK_OPTION) {
        sol.setComment(dialog.getString());

        System.out.println(dialog.getString());
        try {
          sol.commit();
        } catch (JasiCommitException ex) {}

     } else {
        System.out.println("Cancelled");
     }

    }
}

