package org.trinet.jasi;

import java.util.Collection;
import java.util.*;
import org.trinet.util.*;
/**
 * Title:        JASI - Java Abstract Seismic Interface
 * Description:  Your description
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */
/**
 * ChannelTimeModel that selects all channes with phase picks for the given
 * solution and constructs time windows that should include the P and S waves.
 * */
public class PicksOnlyChannelTimeModel extends ChannelTimeWindowModel {

    protected String defModelName = "Picked Channels";

    /** A string with an brief explanation of the model. For help and tooltips. */
    protected String defExplanation =
		   "Channels with phase picks, only.";

    public PicksOnlyChannelTimeModel( ) {
	super ();
	initModel();
    }
    public PicksOnlyChannelTimeModel(Solution sol, ChannelableList channelSet ) {
	super (sol, channelSet);
	initModel();
    }
    public PicksOnlyChannelTimeModel(ChannelableList inputChannelSet ) {
	super(inputChannelSet);
	initModel();
    }
    public PicksOnlyChannelTimeModel(Solution sol ) {
	super(sol);
	initModel();
    }

    protected void initModel () {
	setModelName(defModelName);
	setExplanation(defExplanation);
    }
     /** Return a Collection of Waveform objects selected by the model.
     * The will not contain time-series yet. To load time-series you must set
     * the loader mode with a call to Waveform.setWaveSource(Object)  then load them
     * with Waveform.loadTimeSeries().<p>
     *
     * This model needs a solution with phase picks to determine what channels
     * to select. Returns null if Solution is not set or if Solution has no picks.<p>
     *
     * To be selected a channel must be in the channel list.
     * @see: ChannelTimeWindowModel.setChannelList()
     */
    public Collection getWaveformList() {

        if (sol == null) return null;

	// need phases, if none try to load
    	if (sol.getPhaseList().isEmpty()) sol.addPhases( Phase.create().getBySolution(sol) );
        // still none, bail
	if (sol.getPhaseList().isEmpty()) return null;

	ArrayList wfList = new ArrayList();
	TimeSpan ts;
	Channel chan;
	double dist;

	Phase phase[] = sol.getPhaseList().getArray();

	for (int i=0; i< phase.length; i++) {

	  /// must be in channelSet to be included
	  if (include(phase[i])) {
	    chan = phase[i].chan;
	    dist = phase[i].getDistance();
	    //if (!includeChannel(chanList[i])) continue;  // skip?
	    ts = getTimeWindow(dist);

	    Waveform wf = Waveform.create();
            wf.setChannelObj(chan);
            wf.setTimeSpan(ts);
	    wfList.add(wf);
	  }
	}

	return wfList;
    }

// ///////////////////////////////////////////////////////
    public static void main (String args[])
    {
        if (args.length <= 0) {

          System.out.println ("Usage: ChannelTimeWindowModel [evid] ");
          System.exit(0);

        }

        // event ID
	Long val = Long.valueOf(args[0]);
	long evid = (long) val.longValue();

//	DataSource db = new DataSource();
	DataSource db = new TestDataSource();    // make connection
	System.out.println (db.toString());

	Solution sol    = Solution.create().getById(evid);

	if (sol == null) {
	    System.out.println ("No such event: "+evid);
	    System.exit(0);
	}

//        sol.addPhases( Phase.create().getBySolution(sol) );
        System.out.println (sol.toString());

	System.out.println ("Reading in current channel info...");
/*
        String compList[] = {"EH_", "HH_", "HL_", "AS_"};
    	ChannelList chanList = ChannelList.getByComponent(compList);

	//ChannelList chanList = ChannelList.smartLoad();
	System.out.println ("Read "+chanList.size()+" channels.");
*/
	PicksOnlyChannelTimeModel model = new PicksOnlyChannelTimeModel(sol);

	ArrayList wfList = (ArrayList) model.getWaveformList();

	if (wfList == null) {
	  System.out.println ("No channels in list");
	} else {
	  System.out.println ("Channel count = "+wfList.size());
	}

	// test loading an event from this model
	org.trinet.jiggle.MasterView mv = new org.trinet.jiggle.MasterView();
	WaveClient waveClient = null;

	mv.defineByChannelTimeWindowModel(model);
	System.out.println (mv.toString());

    }

}