package org.trinet.jasi;

import java.util.*;

import org.trinet.util.*;
import org.trinet.util.WaveClient; 

/**
 * ChannelTimeWindowModel that returns a set of Channel/Time-Windows that is
 * derived from the set
 * of waveforms associated with this solution in the DataSource. <p>
 *
 * Created: Mon Aug 28 14:14:55 2000
 *
 * @author Doug Given
 */

public class DataSourceChannelTimeModel extends ChannelTimeWindowModel {

    public DataSourceChannelTimeModel( ) {
	super ();
	initModel();
    }

    public DataSourceChannelTimeModel(Solution sol, ChannelableList channelSet ) {
	super (sol, channelSet);
	initModel();
    }
    public DataSourceChannelTimeModel(ChannelableList inputChannelSet ) {
	super(inputChannelSet);
	initModel();
    }
    public DataSourceChannelTimeModel(Solution sol ) {
	super(sol);
	initModel();
    }

    protected void initModel() {
       setModelName( "DataSource Model");
       setExplanation("Channels defined by dbase associations.");
    }
     /** Return a Collection of Waveform objects selected by the model.
     * They will not contain time-series yet. To load time-series you must set
     * the loader mode with a call to Waveform.setWaveSource(Object) then load them
     * with Waveform.loadTimeSeries().<p>
     *
     * @see: Waveform
     */
    public Collection getWaveformList() {

      // 1st - get the last as defined in the datasource
        ArrayList wfList = new ArrayList(Waveform.create().getBySolution(sol));
				/* DK Bugfix getBySolution() returns a collection, not an ArrayList.  You can't
				 *      cast it up to an ArrayList, because you don't know that that is 
				 *			what was used by the implementor of the function.  Use the appropriate
				 *      constructor instead.
				 */

      //2nd - filter list by comparing to channel list if one was given
	return filterWfListByChannelList(wfList);
    }

// ///////////////////////////////////////////////////////
    public static void main (String args[])
    {
        if (args.length <= 0) {

          System.out.println ("Usage: DataSourceChannelTimeModel [evid] ");
          System.exit(0);

        }

        // event ID
	Long val = Long.valueOf(args[0]);
	long evid = (long) val.longValue();

	DataSource db = new TestDataSource();    // make connection
	System.out.println (db.toString());

	Solution sol    = Solution.create().getById(evid);

	if (sol == null) {
	    System.out.println ("No such event: "+evid);
	    System.exit(0);
	}

        System.out.println (sol.toString());

	System.out.println ("Reading in current channel info...");
        String compList[] = {"EH_", "HH_", "HL_", "AS_"};
    	ChannelList chanList = ChannelList.getByComponent(compList);

	DataSourceChannelTimeModel model =
	        new DataSourceChannelTimeModel(sol, chanList);

	//ArrayList wfList = (ArrayList) model.getWaveformList();
	//System.out.println ("Channel count = "+wfList.size());

	// test loading an event from this model
	org.trinet.jiggle.MasterView mv = new org.trinet.jiggle.MasterView();
	mv.setWaveFormLoadMode(org.trinet.jiggle.MasterView.LoadNone);
	mv.addSolution(sol);
	mv.setSelectedSolution(sol);
	mv.defineByChannelTimeWindowModel(model);

	System.out.println ("wfview count = "+ mv.wfvList.size());

     if (false ) {
	WaveClient waveClient = null;
	String propFile = "waveserver.cfg";
	    try {
		System.out.println ("Creating WaveClient using: "+propFile);
		waveClient = WaveClient.CreateWaveClient().ConfigureWaveClient(propFile); // property file name
		System.out.println (waveClient.toString());

		int nservers = waveClient.numberOfServers();
		if (nservers <= 0) {
		    System.err.println("getDataFromWaveServer Error:"+
				   " no data servers specified in input file: ");
		    System.exit(-1);
		}

	    }
	    catch (Exception ex) {
		System.err.println(ex.toString());
		ex.printStackTrace();
	    }

	Waveform.setWaveSource(waveClient);
	mv.setWaveFormLoadMode(org.trinet.jiggle.MasterView.LoadAllInForeground);
     }

 /*
	Waveform wfa[] = new Waveform[wfList.size()];
	wfList.toArray(wfa);

	for (int i = 0; i<wfa.length; i++)
	    {
		System.out.println (wfa[i].chan.toDelimitedString(' ')+" " +
				    wfa[i].chan.dist.toString()+" "+
                        new TimeSpan(wfa[i].timeStart.doubleValue(),
                                     wfa[i].timeEnd.doubleValue() ).toString() );
	    }

   */
    }

} // ChannelTimeSetModel
