package org.trinet.jasi;
import java.util.*;
import org.trinet.util.*;
// DK import org.trinet.jdbc.table.*;

public abstract class ChannelParms extends JasiObject implements ChannelDataIF, Cloneable {
    protected ChannelIdIF channelId;  // unique description of this channel (CP)
    protected DateRange   dateRange;  // time range over which data is valid (CP)
    protected ChannelDataList cdList; // hash map collection of station channel data parameter objects

    protected ChannelParms() { }

    protected ChannelParms(ChannelIdIF channelId) {
        this.channelId = channelId;
    }

    protected ChannelParms(ChannelIdIF channelId, DateRange dateRange) {
        this(channelId);
        this.dateRange = dateRange;
    }

    public ChannelIdIF getChannelId() {
        return channelId;
    }
    public DateRange getDateRange() {
        return dateRange;
    }
    public boolean hasDateRange() {
        return (dateRange != null);
    }

/**
* Returns true if this instance and input object are of same class and their channel identifiers are equivalent.
* The date ranges and list references may or may not be equivalent.
*/
    public boolean equalsChannel(ChannelDataIF object) {
        if (object == this) return true;
        if (object == null || object.getClass() != this.getClass()) return false;
        ChannelParms chanParms = (ChannelParms) object;
        return channelId.equals(chanParms.channelId);
    }

/**
* Returns true if this instance and input object are of same class and their channel identifiers and date range are equivalent.
*/
    public boolean equalsChannelDateRange(ChannelDataIF object) {
        if (object == this) return true;
        if (object == null || object.getClass() != this.getClass()) return false;
        ChannelParms chanParms = (ChannelParms) object;
        return ( channelId.equals(chanParms.channelId) && dateRange.equals(chanParms.dateRange) );
    }

    public ChannelDataList getList() {
        return cdList;
    }
    public boolean hasList() {
        return (cdList != null);
    }

// TN-NCDC or other database types specific from ChannelDataIF
    public abstract boolean load();
    public abstract boolean load(ChannelIdIF stnchl);
    public abstract ChannelDataIF load(ChannelDataIF chan) ;
    public abstract ChannelDataIF load(ChannelDataIF chan, Date date) ;
    public abstract Collection loadAll();
    public abstract Collection loadAllCurrent() ;
    public abstract Collection loadAll(java.util.Date date) ;

    public boolean equals(Object object) {
        if (object == this) return true;
        if (object == null || object.getClass() != this.getClass()) return false;
        ChannelParms chanParms = (ChannelParms) object;
        return ( channelId.equals(chanParms.channelId) &&
                 dateRange.equals(chanParms.dateRange) &&
                 cdList.equals(chanParms.cdList) );
    }

    public int hashCode() {
        return channelId.hashCode() + dateRange.hashCode();
    }

    // need clone interface implementation
    public Object clone() {
        ChannelParms chanParms = null;
        try {
            chanParms = (ChannelParms) super.clone();
            //chanParms.channelId = (ChannelIdIF) ((ChannelName or DataStnChl) this.channelId).clone();
            chanParms.channelId = (ChannelIdIF) this.channelId.clone();
            chanParms.dateRange = (DateRange) this.dateRange.clone();
            chanParms.cdList = (ChannelDataList) this.cdList.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return chanParms;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(channelId.toString());
        sb.append(" ");
        sb.append(dateRange.toString());
        sb.append(" ");
        return sb.toString();
    }
} // end of class ChannelParms
