package org.trinet.util.graphics.task;
import java.awt.*;
import java.beans.*;
import javax.swing.*; 

/**
  * Creates a JPanel containing a JOptionPane component
  * having "Start", "Stop" and "Cancel" button control
  * over the input AbstractMonitorableTask instance.
*/ 
public abstract class AbstractTaskMonitorOptionPanel extends AbstractTaskMonitorButtonBoxPanel {

    public AbstractTaskMonitorOptionPanel(AbstractMonitorableTask task) {
        super(task);
    }

    protected void initPanelLayout() {
        setLayout(new BorderLayout());
        add(buttonControls, BorderLayout.CENTER);
    }

/** No-op; implelmentation of abstract method. */
    protected void resetControlButtons() {}

/**
  * Returns a JOptionPane component containing the progress monitor.
  * @see #addButtonControlPropertyChangeListener(PropertyChangeListener)
 */
    protected abstract JOptionPane createOptionPane() ;
/**
  * Returns a JOptionPane component containing the progress monitor.
  * @see #addButtonControlPropertyChangeListener(PropertyChangeListener)
 */
    protected Container createControlButtonComponent() {
        return createOptionPane();
    }

/**
  * Disposes the parent container component if it is an instance of Dialog.
*/
    protected void disposeDialog() {
        Component parent = getRootPane().getParent();
        if (parent instanceof Dialog) {
            Dialog dialog = (Dialog) parent;
            dialog.setVisible(false);
            dialog.dispose();
        } 
    }

/**
  * Adds a PropertyChangeListener to the JOptionPane to allow other components to
  * be notified of new button selections.  Note the component does not fire a 
  * PropertyChangeEvent if the button selection has not changed.
*/
    public void addButtonControlPropertyChangeListener(PropertyChangeListener listener) {
        if (buttonControls != null) buttonControls.addPropertyChangeListener(listener);
    }
}
