package org.trinet.jiggle;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import org.trinet.jdbc.*;
import org.trinet.jasi.*;
import org.trinet.jdbc.datatypes.*;

import org.trinet.util.*;
import org.trinet.util.graphics.*;

/**
 */

public class FixDepthButton extends JButton implements ChangeListener {

    MasterView mv;
    //ActiveSolutionList solModel;

    Color fixedColor = Color.red;
    Color freeColor  = getBackground();    // default

    boolean fixed = false;

    public FixDepthButton ()  {
//      setEnabled(false);

      setText("Fix Z");
      setToolTipText("Fix the solution depth");

      setAlignmentY(CENTER_ALIGNMENT);
      setHorizontalTextPosition(AbstractButton.CENTER);
      setVerticalTextPosition(AbstractButton.BOTTOM);

    }

/**
 * Allow selection from a list of Solutions in the MasterView.
 * They are displayed as ID's.
 * The events in the JComboBox are color coded so the user can
 * connect phases with events by color.
 */
    public FixDepthButton (MasterView mv) {

      this();

      this.mv = mv;

      setSolution();

    }

    /** Set button attributes to match solution. */
    public void setSolution () {
       setSolution(mv.solList.getSelected());
    }

    /** Set button attributes to match solution. */
    public void setSolution (Solution sol) {

       if (sol != null) {
	   fixed = sol.depthFixed.booleanValue();

           if (fixed) {
              setBackground(fixedColor);
              setToolTipText("Unfix the solution depth");
           } else {
              setBackground(freeColor);
              setToolTipText("Fix the solution depth");
           }
       }
    }

    /** Toggle the fixed state of thie current event. Returns the fix state. */
    public boolean toggle() {
        Solution sol =  mv.getSelectedSolution();

        // is fixed
        if (sol.depthFixed.booleanValue()) {
            sol.depthFixed.setValue(false);    // unfix it
            mv.solList.setSelected(sol);   // notify
        // ain't fixed
        } else {
            DataDouble result = depthDialog();            // ask for value
            if (!result.isNull()) {
               sol.depth.setValue(result.doubleValue());
               sol.depthFixed.setValue(true);
               mv.solList.setSelected(sol);   // notify
            }
        }

        setSolution();
        return sol.depthFixed.booleanValue();
    }

    /** Dialog to get fix depth. Returned DataDouble is null if dialog is cancelled. */
    public DataDouble depthDialog() {

      DataDouble val = new DataDouble();

      if (mv == null) return val;
      Solution sol = mv.getSelectedSolution();

      if (sol == null) return val;

      Format fmt = new Format("%6.2f");
	 String defStr = fmt.form(sol.depth.doubleValue());

        String newStr = (String) JOptionPane.showInputDialog(
				     null, "Enter depth (km)",
				     "Fix Depth", JOptionPane.QUESTION_MESSAGE,
				     null, null, defStr);

        if (newStr != null) {  // is null if [cancel] is hit
            val.setValue(Double.valueOf(newStr.trim()).doubleValue());
        }

        return val;
    }



// ------ implements StateChangedListener
/** React to external change of Solution state (from solList). Some other component
* can change the Solution or the current Solution's fixed state. */
  public void stateChanged (ChangeEvent e) {

    Object arg = e.getSource();

    if (arg instanceof SolutionList || arg instanceof Solution) {
          setSolution();
    }
  }

}
