package org.trinet.jiggle;

/**
 * A chooser for event types. The containing object must add an actionListener
 * to handle changes made with this chooser.
 *
 * @see org.trinet.jasi.EventTypeMap
 *
 *
 * Created: Fri Feb 18 08:44:48 2000
 *
 * @author Doug Given
 * @version
 */

import java.util.*;
import java.awt.Dimension;
import javax.swing.*;	    // JFC "swing" library
import javax.swing.event.*;
import java.awt.event.*;
import org.trinet.jasi.*;

public class EventTypeChooser extends JPanel implements ChangeListener {

    /** List of event type choices which is defined in org.trinet.jasi.EventTypeMap. */
    String typeChoice[] = EventTypeMap.getEventTypeArray();

    JComboBox typeCombo;

    // remember the ItemListener so we can turn it off when necessary
    ItemListener itemListener;

    String label = "Event Type";
    
    /** Create an EventTypeChooser. Set the current selection to the default
        which is the first item in the list. */
    public EventTypeChooser() {

	//	Box box = Box.createVerticalBox();
	Box box = Box.createHorizontalBox();

	box.add( new JLabel(label) );
     box.add(Box.createHorizontalStrut(5));
     
	typeCombo = makeComboBox(typeChoice, typeChoice[0]);
	box.add(typeCombo);

	add(box);
    }

    /** Create an EventTypeChooser. Set the current selection to item given. */
    public EventTypeChooser(String selectedType) {

	//	Box box = Box.createVerticalBox();
	Box box = Box.createHorizontalBox();

	box.add( new JLabel(label) );

	typeCombo = makeComboBox(typeChoice, selectedType);
	box.add(typeCombo);

	add(box);
	
    }

/**
 * General creation of JComboBoxes given a choice list.
 */
private JComboBox makeComboBox(String[] choiceList, String selectedItem) {

    JComboBox cb = new JComboBox();

    for (int i = 0; i< choiceList.length; i++) {
      cb.addItem(choiceList[i]);
    }

    cb.setEditable(false);		    // don't allow freeform user input
    cb.setSelectedItem(selectedItem);	    // default selection
    cb.setMaximumRowCount(choiceList.length);  // # items displayed in scrolling window

    return cb;
}    
    /** 
     * Sets the selected item in the JComboBox by specifying the object in the list.
     * If <code>item</code> is in the list, the list displays with
     * <code>item</code> selected. If the object does not exist in the list,
     * the default data model selects the first item in the list.
     *
     * @param item  the list object to select
     */
    public void setSelectedItem(Object item) {
     // prevent infinite loop, don't select AGAIN
     if (typeCombo.getSelectedItem() == item) return;
	typeCombo.setSelectedItem(item);
    }

    /** Pass-thru method. */
    public void setEnabled(boolean tf) {
	typeCombo.setEnabled(tf);
    }

    /** Add an action listener */
/*    public void addActionListener (ActionListener listener) {
	    typeCombo.addActionListener(listener);
    }
*/
    /** Add an action listener */
    public void addItemListener (ItemListener listener) {
         itemListener  = listener;
	    typeCombo.addItemListener(itemListener);
    }

/** Handle external solution change. */
    public void stateChanged(ChangeEvent e) {

    Object arg = e.getSource();
    Solution sol;

    if (arg instanceof SolutionList) {
        sol = ((SolutionList)arg).getSelected();
    } else if (arg instanceof Solution) {
	   sol = (Solution)arg;
    } else {
        return;   // noop
    }

    // must turn off item listener else it generates a selection event
    // which we only want for a real user selection
    typeCombo.removeItemListener(itemListener);
    setSelectedItem(sol.getEventTypeString());
    typeCombo.addItemListener(itemListener);
    }

} // EventTypeChooser
