
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import java.util.Collection;
import java.util.ArrayList;
import javax.swing.*;
import javax.swing.border.*;

import java.awt.event.*;
import java.util.*;

import java.util.ArrayList;
import org.trinet.jasi.Waveform;

/** A Dialog panel for choosing how waveforms will be read.
 Sets JiggleProperties.wavefromReadMode value. Allows editing of WaveServerGroup list. */

// This component was built using JBuilder's design tool so the code is messy.

public class DPwaveSource extends JPanel {

     //JiggleProperties props = new JiggleProperties();
     JiggleProperties props;

     JPanel topPanel = new JPanel();
     JPanel middlePanel = new JPanel();
     TitledBorder titledBorder1;
     TitledBorder titledBorder2;
     JRadioButton rbutton1 = new JRadioButton();
     JRadioButton rbutton2 = new JRadioButton();
     ButtonGroup buttonGroup = new ButtonGroup();

     JComboBox wsgBox = new JComboBox();
     JButton editButton = new JButton();
     BorderLayout borderLayout2 = new BorderLayout();
     BorderLayout borderLayout3 = new BorderLayout();
     FlowLayout flowLayout1 = new FlowLayout();

/** Allow selection of waveform reading mode. */
     public DPwaveSource(JiggleProperties props) {

          this.props = props;
          System.out.println (props.listToString());
          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

/** Build the GUI.
This component was built using JBuilder's design tool so the code is messy. */
     protected void jbInit() throws Exception {
          titledBorder1 = new TitledBorder("From Files");
          titledBorder2 = new TitledBorder("From WaveServers");
          this.setLayout(borderLayout3);

          topPanel.setBorder(titledBorder1);
          topPanel.setLayout(borderLayout2);
          middlePanel.setBorder(titledBorder2);
          middlePanel.setLayout(flowLayout1);

	  // GOTCHA! Set selected button BEFORE adding listeners because the
	  // setSelected(true) triggers the action!
          if (props.getInt("waveformReadMode") == Waveform.LoadFromWaveServer) {
		rbutton2.setSelected(true);
          } else {
		rbutton1.setSelected(true);
          }

          rbutton1.setText("Read Waveforms directly: local file, NFS, or via FTP");
          rbutton1.addItemListener(new java.awt.event.ItemListener() {
               public void itemStateChanged(ItemEvent e) {
                    rbutton_itemStateChanged(e);
               }
          });

          rbutton2.setText("Read Waveforms from WaveServer(s)");
          rbutton2.addItemListener(new java.awt.event.ItemListener() {
               public void itemStateChanged(ItemEvent e) {
                    rbutton_itemStateChanged(e);
               }
          });

          // put wsg list in combobox (do before adding listener so no events happen)
          makeWsgBox();

          buttonGroup.add(rbutton1);
          buttonGroup.add(rbutton2);

          editButton.setText("Edit WaveServers");
          editButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    editButton_actionPerformed(e);
               }
          });
          this.add(topPanel, BorderLayout.NORTH);
          topPanel.add(rbutton1, BorderLayout.CENTER);
          this.add(middlePanel, BorderLayout.CENTER);
	  middlePanel.add(rbutton2, null);
          middlePanel.add(wsgBox, null);

	  middlePanel.add(editButton, null);
     }

     void editButton_actionPerformed(ActionEvent e) {
          new WaveServerGroupEditDialog(props);
          // refresh combobox's view, wsg list may have changed
          setWsgList(props.wsgList);
     }

/** Handle radio button events */
     void rbutton_itemStateChanged(ItemEvent e) {
//     System.out.println ("rb state change is 1 selected? "+rbutton1.isSelected());

          if (rbutton1.isSelected()) {
            props.setProperty("waveformReadMode", Waveform.LoadFromDataSource);
            // selectFiles();
            // disable the OTHER selection
            wsgBox.setEnabled(false);
            editButton.setEnabled(false);
            middlePanel.repaint();
          }

          if (rbutton2.isSelected()) {
            props.setProperty("waveformReadMode", Waveform.LoadFromWaveServer);
            // selectServer();
            // disable the OTHER selection
            wsgBox.setEnabled(true);
            editButton.setEnabled(true);
            middlePanel.repaint();
            wsgBox.requestFocus();
          }

     }

/*     private void selectFiles () {
            // disable the OTHER selection
            wsgBox.setEnabled(false);
            editButton.setEnabled(false);
            middlePanel.repaint();
     }

     private void selectServer () {
            // enable other components
            wsgBox.setEnabled(true);
            editButton.setEnabled(true);
            middlePanel.repaint();
            wsgBox.requestFocus();
     }
*/
/** Fill the JComboBox with the items in the wsgList */
     private void makeWsgBox () {

//       middlePanel.remove(wsgBox);    // remove old comboBox

       // make a new one
       wsgBox = new JComboBox();
       wsgBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    wsgBox_actionPerformed(e);
               }
       });


     // put names in list
       if (props.wsgList != null) {

          setWsgList(props.wsgList);
       }

        middlePanel.add(wsgBox, BorderLayout.EAST);
        repaint();

       }

       /** Set the list of WaveServerGroups displayed in the JComboBox. */
       private void setWsgList (Collection coll) {
          try {
            wsgBox.removeAllItems();
          } catch (IndexOutOfBoundsException ex) {} // does this if empty

          ArrayList list = (ArrayList) coll;

          // populate the box from the list
          for (int i = 0; i<list.size(); i++) {
              String name = ((WaveServerGroup)list.get(i)).getName();
              wsgBox.addItem(name);
          }
          // highlight currently selected itme
          WaveServerGroup sel = WaveServerGroup.getSelected(list);
          if (sel == null) {
	      // if list is empty this causes
	      // java.lang.IllegalArgumentException: setSelectedIndex: 0 out of bounds
	      //             wsgBox.setSelectedIndex(0);
          } else {
            wsgBox.setSelectedItem(sel.getName());
          }
       }

     //** Handle combobox action that selects the WaveServerGroup */
     void wsgBox_actionPerformed(ActionEvent e) {

          JComboBox src = (JComboBox) e.getSource();
          String name = (String) src.getSelectedItem();
          // JComboBox.removeAllItems() fires this action! Then returns 'null'!!
          if (name != null) {
              WaveServerGroup wsg = WaveServerGroup.getByName(props.wsgList, name);
              WaveServerGroup.setSelected(wsg, props.wsgList);
          }
          //System.out.println (" combo box: "+name);
     }



     // ///////////////////////////////////////////////////
         public static void main(String s[])
    {

    JiggleProperties props = new JiggleProperties("properties");

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

/*
     WaveServerGroup wsg = new WaveServerGroup("test1");

          wsg.addServer ("spring.gps.caltech.edu", 6500);
          wsg.addServer ("spring.gps.caltech.edu", 6501);
          wsg.addServer ("jet.gps.caltech.edu", 6500);
          wsg.addServer ("jet.gps.caltech.edu", 6501);

          JiggleProperties.wsgList.add(wsg);

      wsg = new WaveServerGroup("test2");

          wsg.addServer ("spring.gps.caltech.edu", 6500);
          wsg.addServer ("spring.gps.caltech.edu", 6501);
          wsg.addServer ("jet.gps.caltech.edu", 6500);
          wsg.addServer ("jet.gps.caltech.edu", 6501);

          JiggleProperties.wsgList.add(wsg);
*/
//          int mode = Waveform.LoadFromDataSource; //JiggleProperties.WavesFromLocalFile;

  System.out.println ("waveformReadMode = "+props.getProperty("waveformReadMode"));
  System.out.println ("Waveform.LoadFromWaveServer = "+Waveform.LoadFromWaveServer);

            props.setProperty("waveformReadMode", Waveform.LoadFromWaveServer);

  System.out.println ("waveformReadMode = "+props.getProperty("waveformReadMode"));

          DPwaveSource dia = new DPwaveSource(props);

          frame.getContentPane().add(dia);


        frame.pack();
        frame.setVisible(true);

    }

}
