package org.trinet.jiggle;

import org.trinet.jasi.Amplitude;

import java.awt.*;

/**
* Triangular graphical marker to show where an amplitude reading is.<p>
*
* Empty triangle means unassociate. Filled means associated.
*
* Colors are the same as for picks and are coded to the associated solution. <br>
*/

public class AmpFlag implements MarkerIF{


    // Default size of symbol in pixels
    final static int minWidth = 8;
    final static int minHeight= 8;

    int width  = minWidth;
    int height = minHeight;

    /** Position of the flag in pixel space. Centered on the amplitude time and
    slammed against the bottom of the WFPanel or viewport. */
    Point pos = new Point();

    /** Amplitude represented by this flag. */
    Amplitude amp;

    /** WFPanel where flag will be drawn. */
    WFPanel wfp;

    /** Current color of the flag. */
    Color color;

    /**
     * Create an amplitude flag representing this Amplitude
     * to be displayed in this WFPanel.
     */
     public AmpFlag (WFPanel wfp, Amplitude amp) {
        this.wfp = wfp;
        this.amp = amp;

     }
       /** Set the marker color. */
       public void  setColor (Color color) {
          this.color = color;
       }

       /** Return the marker color. */
       public Color getColor() {
          return color;
       }

       /** Set the marker size. */
       public void setSize (Dimension dim) {
          width  = (int) dim.getWidth();
          height = (int) dim.getHeight();
       }
       /** Return the marker size. */
       public Dimension getSize() {
          return new Dimension (width, height);
       }
/*
 * Draw the AmpFlag in the Graphics window. Check the Viewport limits to insure
 * that the flag is always in view in a zoomable WFPanel. If isDeleted()
 * == true the flag will NOT be drawn. */
// TODO: handle case where flags overlap

    public void draw (Graphics g) {

	// don't draw a delete phase (later may want to add ability to show these)
	if (amp.isDeleted()) return;

     // If the wfPanel is zoomable keep flag within viewport so we can see it
     Rectangle vrec = wfp.getVisibleRect();
     pos.y = vrec.y + vrec.height;

	// MUST RECALC. THIS EVERY TIME BECAUSE FRAME MIGHT HAVE RESCALED!
	pos.x = wfp.pixelOfTime(amp.datetime.doubleValue()) ;

	// lookup origin's color code

	color = wfp.wfv.mv.solList.getColorOf(amp.getAssociatedSolution());

	g.setColor(color);

     // this makes a point-down triangle at the bottom of the WFPanel
/*     int wid = width/2;
     Polygon triangle = new Polygon();
     triangle.addPoint(pos.x, pos.y);
     triangle.addPoint(pos.x - wid, pos.y - height);
     triangle.addPoint(pos.x + wid, pos.y - height);
*/
     // this makes a point-up triangle at the bottom of the WFPanel
     int wid = width/2;
     Polygon triangle = new Polygon();
     triangle.addPoint(pos.x, pos.y - height);
     triangle.addPoint(pos.x - wid, pos.y);
     triangle.addPoint(pos.x + wid, pos.y);

      // fill if it is "used"
      if (amp.channelMag.weight.doubleValue() == 0.0) {
        g.drawPolygon(triangle);
      } else {
        g.fillPolygon(triangle);
      }

//    if (amp.isAssocated() ) g.fillPolygon(triangle);

    }

} // end of AmpFlag
