package org.trinet.jasi;

import java.util.*;
import javax.swing.event.*;


/**

   An ArrayList that fires state changed events when the list is changed.


*/
public class ActiveArrayList extends ArrayList {

  /** Keep track of "staleness". On creation this is false. */
  boolean hasChanged = false;

public ActiveArrayList() {
}

public ActiveArrayList (Collection col) {
	addAll(col);
}

/** Make an empty ActiveArrayList */
public ActiveArrayList (int initCapacity) {
    super(initCapacity);
}
/** Set state of changed flag.*/
  public void setChanged (boolean tf) {
    hasChanged = tf;
  }

  /** Return true if list has changed since creation. */
  public  boolean hasChanged () {
    return hasChanged;
  }

// **** Pass-thru methods to notify observers ******

/**
 * Given a Collection,  checks to make sure no duplicates are entered.
 * Returns true if objects that were added. */

    public boolean addAll(Collection newList) {

        if (newList == null) return false;  // don't choke on null obj

    	Iterator e = newList.iterator();
	int oldSize = size();

	for (int i=0; i<newList.size(); i++) {
	    add(e.next());
	}

	if (oldSize < size()) {      // some were added
	    fireStateChanged(this);
	    return true;
	 }
	return false;
    }

/**
 * Adds the given Collection of Phases starting at the given index.
 * Checks to make sure no duplicates are
 * entered.  Returns true if phases were added. */
 // addAll(int, Object) weirdly does not return a boolean, so this convolution.
    public boolean addAll(int index, Collection newList) {

     int idx = index;
    	Iterator e = newList.iterator();
     int oldSize = size();

	for (int i=0; i<newList.size(); i++) {
	    add(idx, e.next()) ;
         if (size() > oldSize) {    // if it was added, increment index
           oldSize = size();
           idx++;
         }
     }

	if (idx != index) {      // some were added
        fireStateChanged(this);
        return true;
     }
     return false;
    }

/**
 * Add an object. Will not add object if its already in the list.
 * Returns 'true' if object was added.
 */
    public boolean add(Object obj) {

	return add(obj, true);
    }
/**
 * Add an object. Will not add object if its already in the list.
 * Returns 'true' if object was added. If notify = false, change event will not be
 * fired.
 */
    public boolean add(Object obj, boolean notify) {

	if ( contains(obj) ) return false;

     if (super.add(obj) ) {
        if (notify) fireStateChanged(obj);
        return true;
     }
     return false;
    }
 /**
 * Insert an object at this index. Will not add object if its already in the list.
 * Overrides ArrayList.add() to inforce no-duplicates rule.
 */
    public void add(int index, Object obj)  {

	  if ( contains(obj) ) return;	// no dups
       int oldSize = size();
       super.add(index, obj);

       // it was added
       if (oldSize < size()) fireStateChanged(obj);

    }

/**
 * Remove an object from the list. Returns 'true' if object was removed.
 * Does NOT call the object's delete() method.
 */
    public boolean remove(Object obj)
    {
	if (super.remove(obj)) {
        fireStateChanged(obj);
        return true;
     }
     return false;
    }
/**
 * Remove all object in this range. Returns 'true' if object was removed.
 */
    public void removeRange(int from, int to)
    {
        super.removeRange(from, to);
        fireStateChanged(this);

    }

/**
 * Remove all objects in this collection. Returns 'true' if successful.
 */
    public boolean removeAll(Collection col)
    {
	if (super.removeAll(col)) {
        fireStateChanged(this);
        return true;
     }
     return false;
    }

 /**
 * Remove all objects. Returns 'true' if successful.
 */
    public void clear() {
	super.clear();
	fireStateChanged(this);
    }

    /**
     * Deletes the object from the list. Synonymous with remove().
     * Returns 'true' if object was removed.
     * Does NOT call the object's delete() method. */
    public boolean delete (Object obj) {

 	 return remove(obj);

    }

// ///////////////////////////////////////////////////////
    // Support of state change events
    EventListenerList listenerList = new EventListenerList();
    ChangeEvent changeEvent = null;

    /** Register listener with list of ChangeListeners */
    public void addChangeListener(EventListener l) {
	listenerList.add(ChangeListener.class, l);
    }

    /** Unregister listener from list of ChangeListeners */
    public void removeChangeListener(EventListener l) {
	listenerList.remove(ChangeListener.class, l);
    }

    /** Unregister ALL listeners from list of ChangeListeners */
    public void clearChangeListeners() {
	listenerList = new EventListenerList();
    }

    /** Notify all listeners that have registered interest for notification on
     * this event type.  The event instance is created on each call to reflect the
     * current state. <p> The return from changeEvent.getSource() may be either
     * this list or a single member of this list. */
     protected void fireStateChanged(Object src) {

       setChanged(true);
	// Guaranteed to return a non-null array, :. no NULL check needed
	Object[] listeners = listenerList.getListenerList();

	// bail if no listeners
	if (listenerList.getListenerCount() == 0) return;

	ChangeEvent changeEvent = new ChangeEvent(src);

	// Notify the listeners last to first. Note: 'listeners' is an array of
	// PAIRS of ListenerType/Listener, hence the weird indexing.
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i] == ChangeListener.class) {
		((ChangeListener)listeners[i+1]).stateChanged(changeEvent);
	    }
	}
    }

    /** Return count of registered listeners. */
    public int countListeners() {
      return listenerList.getListenerCount();
    }

    /** Returns the internal model. */
    public EventListenerList getEventListenerList () {
       return listenerList;
    }
    // /////////////////////////////////////////////////////////

/**
 * Main for testing
 */

    public static void main (String args[])  {
	int evid;

	if (args.length <= 0)	// no args
	{

	  evid = 9506369;

	  System.out.println ("Using evid "+ evid+" as a test...");

	} else {

	  Integer val = Integer.valueOf(args[0]);    // convert arg String to 'double'
	  evid = (int) val.intValue();
	}

        System.out.println ("Making connection...");
	DataSource ds = new TestDataSource();

	// NOTE: this demonstrates making a static Channel list.
	//        System.out.println ("Reading in station list...");
	//	Channel.setList (Channel.getAllList());


        System.out.println ("Getting phases  for "+evid);

	// PhaseList phList = (PhaseList) Phase.create().getBySolution(evid);
	 ArrayList phList = (ArrayList) Phase.create().getBySolution(evid);
//	JasiReadingList phList = (JasiReadingList) Phase.create().getBySolution(evid);

	System.out.println ("Number of phases = "+ phList.size());

	ActiveArrayList phaseList = new ActiveArrayList();

	// add the change listener
//	phaseList.addChangeListener(new PhaseChangeListener());

     phaseList.addAll((Collection)phList);

     // create a bogus phase
	Phase newph = Phase.create();
	Channel chan = Channel.create();
	chan.setChannelName("CI", "COK", "EHZ");
        newph.chan = chan;
	newph.description.set("PkP", "I", "U", 3);

     // add it
     System.out.println ("Adding new phase to list: "+newph.toString());
	phaseList.add(newph);

    }


}

/*

    ///////
    class PhaseChangeListener implements ChangeListener {

	public void stateChanged (ChangeEvent changeEvent) {

            Object arg = changeEvent.getSource();

	    System.out.println ("ChangeListener !!");
//	    System.out.println ("arg= "+arg.toString());
         if (arg instanceof Phase) {
            System.out.println ("Seeing new phase to list: "+((Phase)arg).toString());
         }
         if (arg instanceof ActiveArrayList)
            System.out.println ("Seeing list changed, size: "+((ActiveArrayList)arg).size());
         }

     }
*/
