package org.trinet.apps;

import org.trinet.jiggle.*;
import org.trinet.util.WaveClient;
import org.trinet.jasi.*;
import org.trinet.jasi.coda.*;
import org.trinet.util.BenchMark;

/**
   Stand-alone program for calculating the ML of one event.
*/
public class CalcMca {

      static boolean debug = true;
      static boolean useWaveserver = false;

     public CalcMca() {
     }



    public static void main (String args[])
    {

    BenchMark bm = new BenchMark();

  int evid = 0;

  if (args.length <= 0)	// no args
  {
    System.out.println
    ("Usage: CalcMca <evid> ");
    System.exit(0);

  }

  if (args.length > 0) {

    Integer val = Integer.valueOf(args[0]);
    evid = (int) val.intValue();
  }

        System.out.println ("Making connection...");
  DataSource init = new TestDataSource();  // make connection
  init.setWriteBackEnabled(true);

  WaveClient waveClient = null;

  if (useWaveserver) {
      // cheating
      String propFile = "/tpp/www/waveserver.cfg";

      try {
    // Make a WaveClient

    System.out.println ("Creating WaveClient using: "+propFile);

    waveClient = WaveClient.CreateWaveClient().ConfigureWaveClient(propFile); // property file name

    //		System.out.println (waveClient.toString());

    int nservers = waveClient.numberOfServers();
    if (nservers <= 0) {
        System.err.println("getDataFromWaveServer Error:"+
           " no data servers specified in input file: " +
           propFile);
        System.exit(-1);
    }

      }
      catch (Exception ex) {
    System.err.println(ex.toString());
    ex.printStackTrace();
      }
      finally {
    //		if (waveClient != null) waveClient.close();
      }
      Waveform.setWaveSource (waveClient);
  }

// ///////

     if (debug) System.out.println ("Making MasterView for evid = "+evid);

  // Make the "superset" MasterView
  MasterView mv = new MasterView();

  int i = 0;
/*
  mv.setWaveFormLoadMode(MasterView.Cache);
  int above = 50;
  int below = 50;
      mv.setCacheSize (above, below);
*/
     // wave scanner will load them
  mv.setWaveFormLoadMode(MasterView.LoadNone);

 //	mv.setTimeAlign(true);
     bm.print("BenchMark: startup done ");
     bm.reset();

  mv.defineByDataSource(evid);

     bm.print("BenchMark: event parameters loaded ");
     bm.reset();

  // get the first solution in the list
  //	Solution sol = (Solution) mv.solList.solList.get(0);
      Solution sol = null;
     if (mv.solList.size() > 0) {
     sol = (Solution) mv.solList.get(0);

        System.out.println ("SOL: "+sol.toString());
     System.out.println ("There are " + mv.getPhaseCount() +
          " phases, "+ mv.getWFViewCount() + " time series"+
                   " and "+mv.getAmpCount() + " amps");
     } else {
        System.out.println ("No dbase entry found for evid = "+evid);
        System.exit(0);
     }

     // load channel info
     //     if (sol.waveformList.size() > 100) {
 /*
       System.out.println ("Reading in channel list...");

       MasterChannelList.set(ChannelList.smartLoad());

       //       MasterChannelList.set(ChannelList.readCurrentList());
       bm.print("BenchMark: MasterChannelList loaded ");
       bm.reset();
 */
       //}
       System.out.println (" Channel list "+MasterChannelList.get().size());

  // Mca
     String propfile = "MCA.properties";

             System.out.println (sol.fullDump());


     MagnitudeEngine magEng = MagnitudeEngine.CreateMagnitudeEngine("org.trinet.util.magnitudeengines.JiggleMCA");
     magEng.ConfigureMagnitudeEngine(MagnitudeEngine.ConfigurationSourceFile,
                                     propfile,null,
                                     MasterChannelList.get()
                                    );

             System.out.println (sol.fullDump());


     Magnitude newMag = magEng.solve(sol, mv.getWaveformList());

     if (newMag != null) sol.magnitude = newMag;

     // dump result
     System.out.println (sol.magnitude.neatDump());
     bm.print("BenchMark: ");
     System.out.println ("Avg. time per reading = "+
                        bm.getSeconds()/mv.wfvList.size() + " sec");

     sol.magnitude.codaList.clear();

     // recalc with existing codas
     newMag = magEng.solve(sol);
     if (newMag != null) sol.magnitude = newMag;

     // dump result
     System.out.println (sol.magnitude.neatDump());
     bm.print("BenchMark: ");
     System.out.println ("Avg. time per reading = "+
                        bm.getSeconds()/mv.wfvList.size() + " sec");

     // sol.magnitude.commit();

    } // end of main

} // end of class
