package org.trinet.jasi.coda;
import org.trinet.jasi.*;


public class JiggleMCA extends org.trinet.jasi.coda.MCA implements org.trinet.util.graphics.task.ProgressMonitorableIF {

    public JiggleMCA(String propertyFileName, ChannelList channelList) {
        super();
        printOutputStreamHeader(System.out);  // standard rather than file
        initByProperty(propertyFileName);     // file with configuration settings for mca class
        //initEnvironmentInfo();              // try using default values
        setChannelList(channelList);          // note: if ChannelList map is null, creates map when findSimilarInMap invoked
        setMagAssociationDisabled(true);      // disable default MCA summary magnitude association with passed solution
        this.mca = this;                      //
    }

    public Magnitude calcSummaryMag(Solution solution, java.util.Collection waveformList) {
        if (calcChannelMag(solution, waveformList) < 1) return null;        // got no coda data or error
        Coda [] codaArray = currentSol.codaList.getArray();
        if (codaArray == null || codaArray.length < 1) return null;         // shouldn't happen if coda data exists
        return (calcSummaryMag(codaArray)) ? getSummaryMagnitude() : null;  // value legit if codas good
    }

/** Starting progress value */
    public int getMinProgressValue() {
        return 0;
    }

/** Number of waveforms time span eligible for coda calculation. */
    public int getMaxProgressValue() {
        return mca.eligibleCount;
    }

/** Index of waveform in list currently being processed. */
    public int getCurrentProgressValue() {
        return mca.solWaveformToProcessIndex+1;
    }

/** Name of channel currently being processed. */
    public String getProgressMessage() {
        return mca.progressMessageChannelName;
    }
}
