package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.text.*;
import java.math.*;
import org.trinet.jdbc.datatypes.*;
import org.trinet.util.*;

public class DateTimeRenderer extends DefaultTableCellRenderer {
  int fontSize=12;
  Font font;

  public DateTimeRenderer() { 
    super();
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be datetime");
  }
  
  public DateTimeRenderer(int fontSize) { 
    super();
    if (fontSize > 0) this.fontSize = fontSize;
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be datetime");
  }
  
  public DateTimeRenderer(Font font) { 
    super();
    if (font != null) this.font = font;
    else this.font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be datetime");
  }
  
  public int getFontSize() {
    return fontSize;
  }

  public void setFontSize(int fontSize) {
    if (fontSize > 0) this.fontSize = fontSize;
    font = font.deriveFont((float) fontSize);
    this.setFont(font);
  }

    public void setValue(Object value) {
//	if (value instanceof BigDecimal) {
	if (value == null) {
	    super.setValue("");
	}
	else if (value instanceof Number) {
	    super.setValue(EpochTime.epochToString(((Number)value).doubleValue()).substring(0,24));
	}
	else if (value instanceof DataObject) {
	    super.setValue(EpochTime.epochToString(((DataObject)value).doubleValue()).substring(0,24));
	}
	else {
	    super.setValue(value);
	}
    }
}
