package org.trinet.util.graphics.table;
import java.util.*;
import javax.swing.event.*;
import org.trinet.jasi.*;
import org.trinet.jdbc.datatypes.*;
import org.trinet.util.*;

/** Model used to represent a list of jasi Solution objects (SolutionList)
 *  in a JTable. */

// DDG 1/22/01 added COMMENT field

public class CatalogTableModel extends javax.swing.table.AbstractTableModel
	     implements CatalogTableConstants {

    private boolean cellEditable = false;
    private SolutionList solutionList = null;

    public CatalogTableModel() {
    }

    public CatalogTableModel(SolutionList solutionList) {
        this(solutionList, false);
    }

    public CatalogTableModel(SolutionList solutionList, boolean cellEditable) {
	createList(solutionList);
	this.cellEditable = cellEditable;
    }

    public void setCellEditable(boolean cellEditable) {
        this.cellEditable = cellEditable;
    }

    void createList(SolutionList solList) {
	if (solList == null) {
		System.err.println("CatalogTableModel createList(SolutionList) null input param");
		throw new NullPointerException("CatalogTableModel createList(SolutionList) param is null.");
	}
	if (solList.size() <= 0) return;
        this.solutionList = new SolutionList();
	ListIterator iter = solList.listIterator();

	// copy the solution list
	Solution sol;
	while (iter.hasNext()) {
	    sol = (Solution) iter.next();
	    if (sol.isDeleted()) continue;
	    this.solutionList.add(sol);
	}
	solutionList.setSelected(solList.getSelected()); // retain selected sol
    }

    public SolutionList getList() {
        return solutionList;
    }

    public void setList(SolutionList solutionList) {
	createList(solutionList);
	fireTableDataChanged(); // line below equivalent for jdk1.2.2 fireTableChanged(new TableModelEvent(this));
        return;
    }

// Extend AbstractTableModel class and override
    public int getColumnCount() {
        return MAX_FIELDS;
    }

    public Class getColumnClass(int colIndex) {
        return columnClasses[colIndex];
    }

    public String getColumnName(int colIndex) {
        return columnNames[colIndex];
    }

    public int getRowCount() {
        return solutionList.size();
    }

    protected Solution getSolution(int rowIndex) {
	return (Solution) solutionList.get(rowIndex);
    }

/*
    protected Solution copyRow(Solution oldSol) {
	Solution newSol = Solution.create();

	newSol.id		= oldSol.id.clone();
	newSol.externalId	= oldSol.externalId.clone();
	newSol.datetime		= oldSol.datetime.clone();
	newSol.lat		= oldSol.lat.clone();
	newSol.lon		= oldSol.lon.clone();
	newSol.depth		= oldSol.depth.clone();
	newSol.horizDatum	= oldSol.horizDatum.clone();
	newSol.vertDatum	= oldSol.vertDatum.clone();
	newSol.type		= oldSol.type.clone();
	newSol.method		= oldSol.method.clone();
	newSol.crustModel	= oldSol.crustModel.clone();
	newSol.velModel		= oldSol.velModel.clone();
	newSol.authority	= oldSol.authority.clone();
	newSol.source		= oldSol.source.clone();
	newSol.gap		= oldSol.gap.clone();
	newSol.distance		= oldSol.distance.clone();
	newSol.rms		= oldSol.rms.clone();
	newSol.errorTime	= oldSol.errorTime.clone();
	newSol.errorHoriz	= oldSol.errorHoriz.clone();
	newSol.errorVert	= oldSol.errorVert.clone();
	newSol.errorLat		= oldSol.errorLat.clone();
	newSol.errorLon		= oldSol.errorLon.clone();
	newSol.totalReadings	= oldSol.totalReadings.clone();
	newSol.usedReadings	= oldSol.usedReadings.clone();
	newSol.sReadings	= oldSol.sReadings.clone();
	newSol.firstMotions	= oldSol.firstMotions.clone();
	newSol.quality		= oldSol.quality.clone();
	newSol.validFlag	= oldSol.validFlag.clone();
	newSol.eventType	= oldSol.eventType.clone();
	newSol.processingState	= oldSol.processingState.clone();
	newSol.depthFixed	= oldSol.depthFixed.clone();
	newSol.locationFixed	= oldSol.locationFixed.clone();
	newSol.timeFixed	= oldSol.timeFixed.clone();
	newSol.waveRecords	= oldSol.waverecords.clone();
	newSol..magnitude.value	= oldSol.magnitude.value.clone();
	return newSol;
    }
*/
/* The values of the column indexes are defined in CatalogTableConstants. */
    public Object getValueAt(int rowIndex, int colIndex) {
	Solution sl = getSolution(rowIndex);
        switch (colIndex) {
           case ID:
                return sl.id;
           case EXTERNALID:
                return sl.externalId;
           case DATETIME:
                return sl.datetime;    //DataDouble
           case LAT:
                return sl.lat;        //DataDouble
           case LON:
                return sl.lon;        //DataDouble
           case DEPTH:
                return sl.depth;      //DataDouble
           case HORIZDATUM:
                return sl.horizDatum;
           case VERTDATUM:
                return sl.vertDatum;
           case TYPE:
                return sl.type;
           case METHOD:
                return sl.method;
           case CRUSTMODEL:
                return sl.crustModel;
           case VELMODEL:
                return sl.velModel;
           case AUTHORITY:
                return sl.authority;
           case SOURCE:
                return sl.source;
           case GAP:
                return sl.gap;
           case DISTANCE:
                return sl.distance;
           case RMS:
                return sl.rms;
           case ERRORTIME:
                return sl.errorTime;
           case ERRORHORIZ:
                return sl.errorHoriz;
           case ERRORVERT:
                return sl.errorVert;
           case ERRORLAT:
                return sl.errorLat;
           case ERRORLON:
                return sl.errorLon;
           case TOTALREADINGS:
                return sl.totalReadings;
           case USEDREADINGS:
                return sl.usedReadings;
           case SREADINGS:
                return sl.sReadings;
           case FIRSTMOTIONS:
                return sl.firstMotions;
           case QUALITY:
                return sl.quality;
           case VALIDFLAG:
                return sl.validFlag;
           case EVENTTYPE:
                return sl.eventType;
	   case PROCESSINGSTATE:
		return sl.processingState;
           case DEPTHFIXED:
                return sl.depthFixed;
           case LOCATIONFIXED:
                return sl.locationFixed;
           case TIMEFIXED:
                return sl.timeFixed;
           case WAVERECORDS:
                return sl.waveRecords;
           case MAGNITUDE:
                return sl.magnitude.value;
           case MAGTYPE:
                return sl.magnitude.getTypeString();
           case PRIORITY:
                return sl.priority;
           case COMMENT:
                return sl.getComment();
           default:
                return null;
        }
    }

    public void setValueAt(Object value, int rowIndex, int colIndex) {
	Solution sl = getSolution(rowIndex);
        switch (colIndex) {
           case ID:
                sl.id.setValue(value);
                break;
           case EXTERNALID:
                sl.externalId.setValue(value);
                break;
           case DATETIME:
                sl.datetime.setValue(value);
                break;
           case LAT:
                sl.lat.setValue(value);
                break;
           case LON:
                sl.lon.setValue(value);
                break;
           case DEPTH:
                sl.depth.setValue(value);
                break;
           case HORIZDATUM:
                sl.horizDatum.setValue(value);
                break;
           case VERTDATUM:
                sl.vertDatum.setValue(value);
                break;
           case TYPE:
                sl.type.setValue(value);
                break;
           case METHOD:
                sl.method.setValue(value);
                break;
           case CRUSTMODEL:
                sl.crustModel.setValue(value);
                break;
           case VELMODEL:
                sl.velModel.setValue(value);
                break;
           case AUTHORITY:
                sl.authority.setValue(value);
                break;
           case SOURCE:
                sl.source.setValue(value);
                break;
           case GAP:
                sl.gap.setValue(value);
                break;
           case DISTANCE:
                sl.distance.setValue(value);
                break;
           case RMS:
                sl.rms.setValue(value);
                break;
           case ERRORTIME:
                sl.errorTime.setValue(value);
                break;
           case ERRORHORIZ:
                sl.errorHoriz.setValue(value);
                break;
           case ERRORVERT:
                sl.errorVert.setValue(value);
                break;
           case ERRORLAT:
                sl.errorLat.setValue(value);
                break;
           case ERRORLON:
                sl.errorLon.setValue(value);
                break;
           case TOTALREADINGS:
                sl.totalReadings.setValue(value);
                break;
           case USEDREADINGS:
                sl.usedReadings.setValue(value);
                break;
           case SREADINGS:
                sl.sReadings.setValue(value);
                break;
           case FIRSTMOTIONS:
                sl.firstMotions.setValue(value);
                break;
           case QUALITY:
                sl.quality.setValue(value);
                break;
           case VALIDFLAG:
                sl.validFlag.setValue(value);
                break;
           case EVENTTYPE:
                sl.eventType.setValue(value);
                break;
           case PROCESSINGSTATE:
                sl.processingState.setValue(value);
                break;
           case DEPTHFIXED:
                sl.depthFixed.setValue(value);
                break;
           case LOCATIONFIXED:
                sl.locationFixed.setValue(value);
                break;
           case TIMEFIXED:
                sl.timeFixed.setValue(value);
                break;
           case WAVERECORDS:
                sl.waveRecords.setValue(value);
                break;
           case MAGNITUDE:
                sl.magnitude.value.setValue(value);
                break;
           case MAGTYPE:
                sl.magnitude.subScript.setValue(value);
                break;
           case PRIORITY:
                sl.priority.setValue(value);
           case COMMENT:
	        if (value instanceof String)
		      sl.setComment((String)value);
                break;
        }
        fireTableCellUpdated(rowIndex, colIndex);
    }

    public boolean isCellEditable(int rowIndex, int colIndex) {
	if (! cellEditable) return false;
	else if (solutionList.getSolution(rowIndex).isDeleted()) return false;
        else return columnEditable[colIndex];
    }

    public int findColumn(String name) {
        String test = name.trim().toUpperCase();
        for (int index = 0; index < MAX_FIELDS; index++) {
            if (test.equals(getColumnName(index))) return index;
        }
        return -1;
    }

// end of AbstractTableModel methods

    public boolean isKeyColumn(int index) {
        return columnAKey[index];
    }

    public boolean isKeyColumn(String name) {
        return columnAKey[findColumn(name)];
    }

    public int getColumnFractionDigits(int index) {
        return columnFractionDigits[index];
    }

    public boolean isColumnShown(int index) {
        return showColumn[index];
    }

    public boolean isColumnHidden(int index) {
        return ! showColumn[index];
    }

// Methods to modify table rows;
    public boolean deleteRow(int rowIndex) {
	boolean retVal = ((Solution) solutionList.get(rowIndex)).delete();
//        fireTableCellUpdated(rowIndex, 0);
        fireTableCellUpdated(rowIndex, findColumn("id"));
//	fireTableRowsDeleted(rowIndex, rowIndex);  // Virtual table delete not actually deleted from view?
        return retVal;
    };

    public boolean insertRow (int rowIndex, Solution sol) {
       solutionList.add(rowIndex, sol);
       fireTableRowsInserted(rowIndex, rowIndex);
       return true;
    };

    public int updateDB() {
	int count = solutionList.size();
	boolean status = true;
	int trueCount = 0;
	int falseCount = 0;
     try {
	  for (int index = 0; index < count; index ++ ) {
	     status = ((Solution) solutionList.get(index)).commit();
	     if (status) trueCount++;
	     else falseCount++;
	  }
     } catch (JasiCommitException ex) {}
	Debug.println("CatalogTableModel.updateDB() trueCount:" + trueCount +  " falseCount: " + falseCount);
	return trueCount;
    }

}

