package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;
import java.sql.*;
import java.util.*;

public abstract class WhereBasicPt extends WhereAmI {
/** Default constructor does not set a reference point or a database connection */
    public WhereBasicPt() {
	super();
    }
/** Constructor sets the database connection, does not set a reference point. */
    public WhereBasicPt(Connection conn) {
	super(conn);
    }
/** Constructor sets the database connection and reference point. */
    public WhereBasicPt(Connection conn, Geoidal reference) {
	super(conn, reference);
    }
/** Constructor sets the reference point, does not set a database connection. */
    public WhereBasicPt(Geoidal reference) {
	super(reference);
    }
/** Constructor sets the reference point, does not set a database connection. 
* Elevation/depth input parameter is assumed to be in km units.
*/
    public WhereBasicPt(double lat, double lon, double z) {
	super(lat, lon, z);
    }

/** Returns Vector of WhereItems constructed using gazetteer database data for generic type. */
    protected Vector getDatabaseData(String sql) {
	if (items != null) return items; // don't requery database just return cached data

	Vector items = new Vector(256);
	try {
	    Statement sm = conn.createStatement();
	    ResultSet rs = sm.executeQuery(sql); 
	    while (rs.next()) {
		BasicGazetteerPt bgp = new BasicGazetteerPt();
		bgp.lat = rs.getDouble("LAT");	
		bgp.lon = rs.getDouble("LON");	
		bgp.z = rs.getDouble("Z");	
		bgp.name = rs.getString("NAME");	
		bgp.state = rs.getString("STATE");	
		if (rs.wasNull()) bgp.state = "";
		bgp.remark = rs.getString("REMARK");	
		if (rs.wasNull()) bgp.remark = "NULL";
		WhereItem whereItem = new WhereItemBasicPt(reference, bgp);
		items.addElement(whereItem);
	    }
	    rs.close();
	    sm.close();
	}
	catch (SQLException ex) {
	    ex.printStackTrace();
	    return null;
	}
	return items;
    }
}
